/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.files;

import com.semmle.util.data.StringUtil;
import java.util.regex.Pattern;

public class PathMatcher {
    private final Mode mode;
    private final Pattern pattern;
    private final String originalPattern;

    public PathMatcher(String pattern) {
        this(Mode.Ant, pattern);
    }

    public PathMatcher(Mode mode, String pattern) {
        this.mode = mode;
        this.originalPattern = pattern;
        StringBuilder b = new StringBuilder();
        this.toRegex(b, pattern);
        this.pattern = Pattern.compile(b.toString());
    }

    public PathMatcher(Iterable<String> patterns) {
        this(Mode.Ant, patterns);
    }

    public PathMatcher(Mode mode, Iterable<String> patterns) {
        this.mode = mode;
        this.originalPattern = patterns.toString();
        StringBuilder b = new StringBuilder();
        for (String pattern : patterns) {
            if (b.length() > 0) {
                b.append('|');
            }
            this.toRegex(b, pattern);
        }
        this.pattern = Pattern.compile(b.toString());
    }

    private void toRegex(StringBuilder b, String pattern) {
        if (pattern.length() == 0) {
            return;
        }
        pattern = pattern.replace('\\', '/');
        pattern = pattern.replaceAll("//+", "/");
        pattern = StringUtil.escapeStringLiteralForRegexp(pattern, "*?");
        if (this.mode == Mode.Ant && pattern.endsWith("/")) {
            pattern = pattern + "**";
        }
        if (this.mode == Mode.CodeqlConfig && !pattern.endsWith("**")) {
            pattern = pattern + "/**";
        }
        int i = 0;
        if (this.mode == Mode.Rsync) {
            if (pattern.charAt(0) == '/') {
                b.append("/?");
                ++i;
            } else {
                b.append("(.*/)?");
            }
        }
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (c == '*' && i < pattern.length() - 2 && pattern.charAt(i + 1) == '*' && pattern.charAt(i + 2) == '/') {
                b.append("(?:^|.*/)");
                i += 3;
                continue;
            }
            if (c == '*' && i < pattern.length() - 1 && pattern.charAt(i + 1) == '*') {
                b.append(".*");
                i += 2;
                continue;
            }
            if (c == '*') {
                b.append("[^/]*");
                ++i;
                continue;
            }
            if (c == '?') {
                b.append("[^/]");
                ++i;
                continue;
            }
            b.append(c);
            ++i;
        }
    }

    public boolean matches(String path) {
        if ((path = path.replace('\\', '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return this.pattern.matcher(path).matches();
    }

    public String toString() {
        return "Matches " + this.originalPattern + " [" + this.pattern + "]";
    }

    public static enum Mode {
        Ant,
        CodeqlConfig,
        Rsync;

    }
}

