/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io;

import com.semmle.util.io.WriterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;

public abstract class LineBufferOutputStream
extends OutputStream {
    private final boolean interpretCR;
    private final WriterOutputStream writerOutputStream;
    private char[] lineBuffer = new char[16];
    private int cursor = 0;
    private int lineBufferCount = 0;

    public LineBufferOutputStream(Charset charset) {
        this(charset, false);
    }

    public LineBufferOutputStream(Charset charset, boolean interpretCR) {
        this.writerOutputStream = new WriterOutputStream(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                int start = off;
                for (int i = off; i < off + len; ++i) {
                    if (cbuf[i] != '\n' && cbuf[i] != '\r') continue;
                    if (i - start > 0) {
                        LineBufferOutputStream.this.writeToLineBuffer(cbuf, start, i - start);
                    }
                    if (!(LineBufferOutputStream.this.lineBufferCount == 0 || LineBufferOutputStream.this.interpretCR && cbuf[i] == '\r')) {
                        LineBufferOutputStream.this.outputInternal(true);
                    }
                    LineBufferOutputStream.this.cursor = 0;
                    start = i + 1;
                }
                if (start != len) {
                    int fragmentLength = off + len - start;
                    LineBufferOutputStream.this.writeToLineBuffer(cbuf, start, fragmentLength);
                    LineBufferOutputStream.this.cursor = LineBufferOutputStream.this.cursor + fragmentLength;
                }
            }

            @Override
            public void close() {
            }

            @Override
            public void flush() {
            }
        }, charset);
        this.interpretCR = interpretCR;
    }

    @Override
    public void write(int b) throws IOException {
        this.writerOutputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writerOutputStream.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writerOutputStream.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.writerOutputStream.flush();
        this.outputInternal(false);
    }

    @Override
    public void close() throws IOException {
        this.writerOutputStream.close();
        this.outputInternal(false);
    }

    private void writeToLineBuffer(char[] cbuf, int off, int len) {
        int minimumCapacity = this.cursor + len;
        if (minimumCapacity - this.lineBuffer.length > 0) {
            int newCapacity = this.lineBuffer.length * 2 + 2;
            if (newCapacity - minimumCapacity < 0) {
                newCapacity = minimumCapacity;
            }
            this.lineBuffer = Arrays.copyOf(this.lineBuffer, newCapacity);
        }
        System.arraycopy(cbuf, off, this.lineBuffer, this.cursor, len);
        this.lineBufferCount = Math.max(this.lineBufferCount, this.cursor + len);
    }

    private void outputInternal(boolean triggeredByNewline) throws IOException {
        this.output(triggeredByNewline);
        this.clearBuffer();
    }

    protected abstract void output(boolean var1) throws IOException;

    protected boolean hasBufferedContent() {
        return this.lineBufferCount != 0;
    }

    private void clearBuffer() {
        this.lineBufferCount = 0;
        this.cursor = 0;
    }

    protected String getBufferContents() {
        return new String(this.lineBuffer, 0, this.lineBufferCount);
    }
}

