/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io;

import com.semmle.util.exception.CatastrophicError;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class StreamUtil {
    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        StreamUtil.nullCheck(inputStream, outputStream);
        long total = 0L;
        byte[] bytes = new byte[1024];
        while ((read = inputStream.read(bytes)) > 0) {
            outputStream.write(bytes, 0, read);
            total += (long)read;
        }
        return total;
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        int read;
        StreamUtil.nullCheck(reader, writer);
        long total = 0L;
        char[] chars = new char[1024];
        while ((read = reader.read(chars)) > 0) {
            writer.write(chars, 0, read);
            total += (long)read;
        }
        return total;
    }

    public static long limitedCopy(InputStream inputStream, OutputStream outputStream, long length) throws IOException {
        int read;
        StreamUtil.nullCheck(inputStream, outputStream);
        long total = 0L;
        byte[] bytes = new byte[1024];
        while ((read = inputStream.read(bytes, 0, (int)Math.min((long)bytes.length, length))) > 0) {
            outputStream.write(bytes, 0, read);
            length -= (long)read;
            total += (long)read;
        }
        return total;
    }

    private static void nullCheck(Object input, Object output) {
        CatastrophicError.throwIfAnyNull(input, output);
    }

    public static boolean skip(InputStream stream, long n) throws IOException {
        long skipped;
        if (n <= 0L) {
            return true;
        }
        for (long toSkip = n - 1L; toSkip > 0L; toSkip -= skipped) {
            skipped = stream.skip(toSkip);
            if (skipped != 0L) continue;
            if (stream.read() == -1) {
                return false;
            }
            ++skipped;
        }
        return stream.read() != -1;
    }

    public static byte[] readN(InputStream stream, int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        StreamUtil.limitedCopy(stream, bOut, n);
        return bOut.toByteArray();
    }

    public static int read(InputStream stream, byte[] buf, int offset, int length) throws IOException {
        int read;
        if (length < 0) {
            throw new IllegalArgumentException("length must be positive");
        }
        int total = 0;
        while ((read = stream.read(buf, offset, length)) > 0) {
            length -= read;
            total += read;
        }
        return total;
    }

    public static BufferedReader newUTF8BufferedReader(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    public static BufferedWriter newUTF8BufferedWriter(OutputStream outputStream) {
        return new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
    }
}

