/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io;

import com.semmle.util.exception.CatastrophicError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class WriterOutputStream
extends OutputStream {
    private Writer writer;
    private CharsetDecoder decoder;
    private ByteBuffer byteBuffer = ByteBuffer.allocate(128);
    private CharBuffer charBuffer = CharBuffer.allocate(1024);

    public WriterOutputStream(Writer writer, Charset charset) {
        this.writer = writer;
        this.decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?");
    }

    @Override
    public void flush() throws IOException {
        this.processBuffer(false);
        this.outputChars();
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.processBuffer(true);
        this.outputChars();
        this.writer.close();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            if (!this.byteBuffer.hasRemaining()) {
                this.processBuffer(false);
            }
            int toWrite = Math.min(this.byteBuffer.remaining(), len);
            this.byteBuffer.put(b, off, toWrite);
            len -= toWrite;
            off += toWrite;
        }
    }

    public void processBuffer(boolean eof) throws IOException {
        this.byteBuffer.flip();
        while (this.byteBuffer.remaining() > 0) {
            CoderResult result = this.decoder.decode(this.byteBuffer, this.charBuffer, eof);
            if (result.isOverflow()) {
                this.outputChars();
                continue;
            }
            if (result.isUnderflow()) break;
            if (!result.isError()) continue;
            throw new CatastrophicError("We got an error with a decoder that replaces errors");
        }
        this.byteBuffer.compact();
    }

    private void outputChars() throws IOException {
        this.charBuffer.flip();
        this.writer.append(this.charBuffer);
        this.charBuffer.clear();
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            this.processBuffer(false);
        }
        this.byteBuffer.put((byte)b);
    }
}

