/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io.csv;

import com.semmle.util.io.csv.CSVParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class CSVReader
implements Closeable {
    private final BufferedReader br;
    private boolean hasNext = true;
    private final CSVParser parser;
    private final int skipLines;
    private boolean linesSkipped;
    private int curline = 0;
    private int startLine = 0;
    private static final int DEFAULT_SKIP_LINES = 0;

    public CSVReader(Reader reader) {
        this(reader, ',', '\"', '\"', 0, false);
    }

    private CSVReader(Reader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes) {
        this.br = new BufferedReader(reader);
        this.parser = new CSVParser(separator, quotechar, escape, strictQuotes);
        this.skipLines = line;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> allElements = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] nextLineAsTokens = this.readNext();
            if (nextLineAsTokens == null) continue;
            allElements.add(nextLineAsTokens);
        }
        return allElements;
    }

    public String[] readNext() throws IOException {
        boolean first = true;
        String[] result = null;
        do {
            String nextLine = this.getNextLine();
            if (first) {
                this.startLine = this.curline;
                first = false;
            }
            if (!this.hasNext) {
                return result;
            }
            String[] r = this.parser.parseLineMulti(nextLine);
            if (r.length <= 0) continue;
            if (result == null) {
                result = r;
                continue;
            }
            String[] t = new String[result.length + r.length];
            System.arraycopy(result, 0, t, 0, result.length);
            System.arraycopy(r, 0, t, result.length, r.length);
            result = t;
        } while (this.parser.isPending());
        return result;
    }

    private String getNextLine() throws IOException {
        String nextLine;
        if (!this.linesSkipped) {
            for (int i = 0; i < this.skipLines; ++i) {
                this.br.readLine();
                ++this.curline;
            }
            this.linesSkipped = true;
        }
        if ((nextLine = this.br.readLine()) == null) {
            this.hasNext = false;
        } else {
            ++this.curline;
        }
        return this.hasNext ? nextLine : null;
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }

    public int getStartLine() {
        return this.startLine;
    }
}

