/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.logging;

import ch.qos.logback.classic.Level;
import com.semmle.util.io.LineBufferOutputStream;
import com.semmle.util.logging.LogbackUtils;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class LogOutputStream
extends LineBufferOutputStream {
    private final Marker category;
    private final Logger log;
    private final Level level;

    public LogOutputStream(Logger log, Marker category, boolean interpretCR) {
        this(log, category, interpretCR, Level.INFO);
    }

    public LogOutputStream(Logger log, Marker category, boolean interpretCR, Level level) {
        super(Charset.defaultCharset(), interpretCR);
        this.category = category;
        this.log = log;
        this.level = level;
    }

    @Override
    protected void output(boolean triggeredByNewline) {
        if (this.hasBufferedContent()) {
            String s = this.getBufferContents();
            LogbackUtils.logAtLevel(this.log, this.level, this.category, s);
        }
    }
}

