/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.process;

import com.semmle.util.exception.Exceptions;
import com.semmle.util.expansion.ExpansionEnvironment;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;

public class Env {
    private static final int DEFAULT_RAM_MB_32 = 1024;
    private static final int DEFAULT_RAM_MB = 4096;
    private static final Env instance = new Env();
    private final Stack<Map<String, String>> envVarContexts = new Stack();

    public static synchronized Env systemEnv() {
        return instance;
    }

    public static Env emptyEnv() {
        Env env = new Env();
        env.envVarContexts.clear();
        env.envVarContexts.push(Collections.unmodifiableMap(Env.makeContext()));
        return env;
    }

    private static Map<String, String> makeContext() {
        if (Env.getOS().equals((Object)OS.WINDOWS)) {
            return new TreeMap<String, String>((a, b) -> a.toUpperCase(Locale.ENGLISH).compareTo(b.toUpperCase(Locale.ENGLISH)));
        }
        return new LinkedHashMap<String, String>();
    }

    public Env() {
        Map<String, String> env = Env.makeContext();
        try {
            env.putAll(System.getenv());
        }
        catch (SecurityException ex) {
            Exceptions.ignore(ex, "Treat an inaccessible environment variable as not existing");
        }
        this.envVarContexts.push(Collections.unmodifiableMap(env));
    }

    public synchronized void unsetAll(Collection<String> names) {
        if (!names.isEmpty()) {
            Map<String, String> map = this.envVarContexts.pop();
            map = new LinkedHashMap<String, String>(map);
            for (String name : names) {
                map.remove(name);
            }
            this.envVarContexts.push(Collections.unmodifiableMap(map));
        }
    }

    public synchronized Map<String, String> getenv() {
        return this.envVarContexts.peek();
    }

    public synchronized String get(Var var) {
        return this.get(var.name());
    }

    public String getOrDefault(Var var, String def) {
        String result = this.get(var.name());
        if (result != null) {
            return result;
        }
        return def;
    }

    public synchronized String get(String envVarName) {
        return this.getenv().get(envVarName);
    }

    public synchronized String getNonEmpty(Var var) {
        return this.getNonEmpty(var.name());
    }

    public synchronized String getPossiblyEmpty(String envVarName) {
        String got = this.getenv().get(envVarName);
        return got != null ? got : "";
    }

    public synchronized String getNonEmpty(String envVarName) {
        String s = this.get(envVarName);
        return s == null || s.isEmpty() ? null : s;
    }

    public synchronized String getFirstNonEmpty(String ... envVarNames) {
        for (String envVarName : envVarNames) {
            String s = this.getNonEmpty(envVarName);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public synchronized String getFirstNonEmpty(Var ... envVars) {
        String[] envVarNames = new String[envVars.length];
        for (int i = 0; i < envVars.length; ++i) {
            envVarNames[i] = envVars[i].name();
        }
        return this.getFirstNonEmpty(envVarNames);
    }

    public boolean getBoolean(Var var) {
        return this.getBoolean(var.name());
    }

    public boolean getBoolean(String envVarName) {
        return this.getBoolean(envVarName, false);
    }

    public boolean getBoolean(Var var, boolean def) {
        return this.getBoolean(var.name(), def);
    }

    public boolean getBoolean(String envVarName, boolean def) {
        String v = this.get(envVarName);
        return v == null ? def : Boolean.parseBoolean(v);
    }

    public int getInt(Var var, int defaultValue) {
        return this.getInt(var.name(), defaultValue);
    }

    public int getInt(String envVarName, int defaultValue) {
        String value = this.get(envVarName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Exceptions.ignore(e, "We'll just use the default value.");
            return defaultValue;
        }
    }

    public synchronized void pushEnvironmentContext(Map<String, String> addedValues) {
        Map<String, String> newValues = Env.makeContext();
        newValues.putAll(this.envVarContexts.peek());
        newValues.putAll(addedValues);
        this.envVarContexts.push(Collections.unmodifiableMap(newValues));
    }

    public synchronized void popEnvironmentContext() {
        this.envVarContexts.pop();
    }

    public synchronized void addEnvironmentToNewProcess(ProcessBuilder builder) {
        if (this.envVarContexts.size() > 1) {
            builder.environment().putAll(this.envVarContexts.peek());
        }
    }

    public synchronized void addEnvironmentToNewEnv(ExpansionEnvironment env) {
        if (this.envVarContexts.size() > 1) {
            env.defineVars(this.envVarContexts.peek());
        }
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static OS getOS() {
        String name = Env.getOSName();
        if (name == null) {
            return OS.UNKNOWN;
        }
        if (name.contains("Windows")) {
            return OS.WINDOWS;
        }
        if (name.contains("Mac OS X")) {
            return OS.MACOS;
        }
        if (name.contains("Linux")) {
            return OS.LINUX;
        }
        return OS.UNKNOWN_UNIX;
    }

    public Architecture tryDetermineJvmArchitecture() {
        String value = System.getProperty("sun.arch.data.model");
        if ("32".equals(value)) {
            return Architecture.X86;
        }
        if ("64".equals(value)) {
            return Architecture.X64;
        }
        long maxHeap = Runtime.getRuntime().maxMemory();
        if (maxHeap < Long.MAX_VALUE && maxHeap >= 0x100000000L) {
            return Architecture.X64;
        }
        String osArch = System.getProperty("os.arch");
        if ("x86".equals(osArch) || "i386".equals(osArch)) {
            return Architecture.X86;
        }
        if ("x86_64".equals(osArch) || "amd64".equals(osArch)) {
            return Architecture.X64;
        }
        return Architecture.UNDETERMINED;
    }

    public int defaultRamMb() {
        return this.getInt(Var.SEMMLE_DEFAULT_HEAP_SIZE, this.tryDetermineJvmArchitecture().is32Bit() ? 1024 : 4096);
    }

    public static enum OS {
        WINDOWS(false, false),
        LINUX(true, true),
        MACOS(false, true),
        UNKNOWN_UNIX(true, true),
        UNKNOWN(true, true);

        private final boolean fileSystemCaseSensitive;
        private final boolean envVarsCaseSensitive;

        private OS(boolean fileSystemCaseSensitive, boolean envVarsCaseSensitive) {
            this.fileSystemCaseSensitive = fileSystemCaseSensitive;
            this.envVarsCaseSensitive = envVarsCaseSensitive;
        }

        public static OS fromDisplayName(String name) {
            if (name != null) {
                if ("WINDOWS".equals(name = name.toUpperCase())) {
                    return WINDOWS;
                }
                if ("LINUX".equals(name)) {
                    return LINUX;
                }
                if ("MACOS".equals(name.replace(" ", ""))) {
                    return MACOS;
                }
            }
            throw new IllegalArgumentException("No OS type found with name " + name);
        }

        public boolean isFileSystemCaseSensitive() {
            return this.fileSystemCaseSensitive;
        }

        public boolean isEnvironmentCaseSensitive() {
            return this.envVarsCaseSensitive;
        }

        public boolean isPosix() {
            return this != WINDOWS;
        }

        public String getShortName() {
            switch (this) {
                case WINDOWS: {
                    return "win";
                }
                case LINUX: {
                    return "linux";
                }
                case MACOS: {
                    return "osx";
                }
            }
            return "unknown";
        }
    }

    public static enum Var {
        ODASA_HOME,
        SEMMLE_HOME,
        SEMMLE_DATA,
        SEMMLE_CACHE,
        SEMMLE_DIST,
        SEMMLE_GIT_ROOT,
        SEMMLE_QUERY_ROOT,
        SEMMLE_LOCK_DIR,
        SEMMLE_LICENSE_DIR,
        ODASA_QUERIES,
        ODASA_TOOLS,
        ODASA_PROTOTYPE_MODE,
        SEMMLE_COMPILATION_CACHE,
        SEMMLE_OVERRIDE_OPTIMISER_VERSION,
        SEMMLE_NO_COMPILATION_CACHING,
        SEMMLE_COMPILATION_CACHE_SIZE,
        SEMMLE_JAVA_HOME,
        ODASA_JAVA_HOME,
        SEMMLE_JAVA_TOOL_OPTIONS,
        CODEQL_IN_PROCESS,
        ODASA_IN_PROCESS,
        SEMMLE_TRAP_IMPORTER,
        SEMMLE_PRESERVE_SYMLINKS,
        SEMMLE_PATH_TRANSFORMER,
        SEMMLE_CREDENTIALS_PASSWORD,
        LGTM_CREDENTIALS_PASSWORD,
        SEMMLE_JAVA_ARGS,
        CODEQL_LOG_MARKER_ALLOWLIST,
        SEMMLE_LOG_LEVELS,
        SEMMLE_DEFAULT_HEAP_SIZE,
        SEMMLE_MAX_RAM_MB,
        SEMMLE_SYNCHRONOUS_LOGGING,
        SEMMLE_MEMORY_MAPPING,
        SEMMLE_METRICS_DIR,
        SEMMLE_UNIT_TEST_MODE,
        SEMMLE_DEBUG_QL_IN_QLO,
        CODEQL_ASSERTIONS,
        ODASA_ASSERTIONS,
        ODASA_EXTRA_VARIABLES,
        ODASA_TUNE_GC,
        SEMMLE_ODASA_DEBUG,
        SEMMLE_PYTHON,
        SEMMLE_PLATFORM,
        SEMMLE_PLATFORM_TOOLS,
        CODEQL_TOOL_PATH,
        CODEQL_BDD_RESET_FRACTION,
        SEMMLE_MAX_TRAP_ERRORS,
        SEMMLE_MAX_TRAP_INMEMORY_TUPLES,
        SEMMLE_MAX_TRAP_MERGE,
        SEMMLE_COPY_EXECUTABLES,
        SEMMLE_COPY_EXECUTABLES_SUPER_ROOT,
        SEMMLE_COPY_EXECUTABLES_ROOT,
        SEMMLE_WINDOWS_RUNNER_BINARY,
        SEMMLE_INTERCEPT_VERBOSITY,
        ODASA_JAVAC_VERBOSE,
        ODASA_JAVA_CLASS_ORIGIN_TRACKING,
        ODASA_JAVAC_CORRECT_EXCEPTIONS,
        ODASA_JAVAC_EXTRA_CLASSPATH,
        ODASA_NO_ECLIPSE_BUILD,
        ODASA_PROJECT,
        ODASA_SNAPSHOT,
        ODASA_SNAPSHOT_NAME,
        ODASA_SRC,
        ODASA_DB,
        ODASA_BUILD_ERROR_DIR,
        TRAP_FOLDER,
        SOURCE_ARCHIVE,
        ODASA_OUTPUT,
        ODASA_SUBPROJECT_THREADS,
        ODASA_JAVA_LAYOUT,
        ODASA_CPP_LAYOUT,
        ODASA_CSHARP_LAYOUT,
        ODASA_PYTHON_LAYOUT,
        ODASA_JAVASCRIPT_LAYOUT,
        JAVA_HOME,
        PATH,
        LINUX_VARIANT,
        HTTP_PROXY,
        http_proxy,
        HTTPS_PROXY,
        https_proxy,
        NO_PROXY,
        no_proxy,
        CODEQL_ACTION_RUN_MODE,
        CODEQL_ACTION_VERSION,
        CODEQL_TRACER_DIAGNOSTICS_DIR,
        CODEQL_TRACER_LANGUAGES,
        CODEQL_TRACER_LOG,
        CODEQL_TRACER_EXTRA_CONFIG,
        CODEQL_ENABLE_EXPERIMENTAL_FEATURES,
        CODEQL_ENABLE_EXPERIMENTAL_FEATURES_SWIFT,
        SEMMLE_PRELOAD_libtrace,
        SEMMLE_PRELOAD_libtrace32,
        SEMMLE_PRELOAD_libtrace64,
        SEMMLE_OVERRIDE_LIBTRACE,
        SEMMLE_OVERRIDE_LIBTRACE32,
        SEMMLE_OVERRIDE_LIBTRACE64,
        CODEQL_PYTHON_LEGACY_TEST_EXTRACTION_VERSION;

    }

    public static enum Architecture {
        X86(true, false),
        X64(false, true),
        UNDETERMINED(false, false);

        private final boolean is32Bit;
        private final boolean is64Bit;

        private Architecture(boolean is32Bit, boolean is64Bit) {
            this.is32Bit = is32Bit;
            this.is64Bit = is64Bit;
        }

        public boolean is32Bit() {
            return this.is32Bit;
        }

        public boolean is64Bit() {
            return this.is64Bit;
        }
    }
}

