/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.trap;

import com.semmle.util.exception.ResourceError;
import com.semmle.util.files.FileUtil;
import com.semmle.util.io.csv.CSVReader;
import com.semmle.util.trap.TrapWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVtoTRAP
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(CSVtoTRAP.class);
    private final CSVReader reader;
    private final TrapWriter writer;
    private final String path;

    public static void convertDirectory(File csvDir, File trapDir) {
        FileFilter filter = FileUtil.extensionFilter(false, ".csv");
        for (File csv : FileUtil.recursiveFind(csvDir, filter)) {
            try {
                String path = FileUtil.relativePath(csv, csvDir);
                File trap = new File(trapDir, path + ".trap.gz");
                CSVtoTRAP.convert(csv, trap, path);
            }
            catch (RuntimeException e) {
                logger.error("Could not convert " + csv, e);
            }
        }
    }

    private static void convert(File csv, File trap, String path) {
        File dir = trap.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new ResourceError("Could not create directory: " + dir);
        }
        CSVtoTRAP.convert(csv, new TrapWriter(trap), path);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void convert(File csv, TrapWriter trap, String path) {
        CSVtoTRAP converter = null;
        try {
            converter = new CSVtoTRAP(csv, trap, path);
            converter.convert();
        }
        catch (FileNotFoundException e) {
            try {
                throw new ResourceError("CSV file does not exist: " + csv, e);
                catch (IOException e2) {
                    throw new ResourceError("Could not read CSV file: " + csv, e2);
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(converter);
                throw throwable;
            }
        }
        FileUtil.close(converter);
    }

    private CSVtoTRAP(File csv, TrapWriter writer, String path) throws FileNotFoundException {
        this.reader = new CSVReader(new FileReader(csv));
        this.writer = writer;
        this.path = path;
    }

    private void convert() throws IOException {
        String[] tuple;
        while ((tuple = this.reader.readNext()) != null) {
            TrapWriter.Label row = this.writer.freshLabel();
            for (int i = 0; i < tuple.length; ++i) {
                this.writer.addTuple("externalData", row, this.path, i, tuple[i]);
            }
        }
    }

    @Override
    public void close() {
        FileUtil.close(this.reader);
        FileUtil.close(this.writer);
    }
}

