/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.unicode;

public class UTF8Util {
    public static int encodablePrefixLength(String str, int maxEncodedLength) {
        if (str.length() > maxEncodedLength / 3) {
            int encodedLength = 0;
            for (int i = 0; i < str.length(); ++i) {
                int oldI = i;
                char c = str.charAt(i);
                if (c <= '\u007f') {
                    ++encodedLength;
                } else if (c <= '\u07ff') {
                    encodedLength += 2;
                } else if (Character.isHighSurrogate(c)) {
                    if (i + 1 < str.length() && Character.isLowSurrogate(str.charAt(i + 1))) {
                        encodedLength += 4;
                        ++i;
                    } else {
                        encodedLength += 3;
                    }
                } else {
                    encodedLength += 3;
                }
                if (encodedLength <= maxEncodedLength) continue;
                return oldI;
            }
        }
        return str.length();
    }
}

