/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.xml;

import com.semmle.util.data.Pair;
import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.exception.Exceptions;
import com.semmle.util.exception.ResourceError;
import com.semmle.util.exception.UserError;
import com.semmle.util.xml.AlwaysEmptyResolver;
import com.semmle.util.xml.DummyXMLType;
import com.thaiopensource.relaxng.jaxp.CompactSyntaxSchemaFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XML {
    private static WeakReference<Pair<Class<?>, JAXBContext>> lastContext;
    private static WeakReference<Pair<Class<?>, Schema>> lastSchema;

    public static synchronized <T> JAXBContext getContext(Class<T> type) {
        JAXBContext context;
        Pair<Class<T>, JAXBContext> cachedContext;
        Pair<Class<T>, JAXBContext> pair = cachedContext = lastContext == null ? null : (Pair<Class<T>, JAXBContext>)lastContext.get();
        if (cachedContext != null && cachedContext.fst() == type) {
            return (JAXBContext)cachedContext.snd();
        }
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(XML.class.getClassLoader());
            context = JAXBContext.newInstance((Class[])new Class[]{type, DummyXMLType.class});
        }
        catch (JAXBException e) {
            throw new CatastrophicError("Could not create JAXB context for " + type.getCanonicalName(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
        cachedContext = Pair.make(type, context);
        lastContext = new WeakReference<Pair<Class<T>, JAXBContext>>(cachedContext);
        return context;
    }

    public static synchronized <T> Schema getSchema(Class<T> type) {
        Pair<Class<T>, Schema> cachedSchema;
        Pair<Class<T>, Schema> pair = cachedSchema = lastSchema == null ? null : (Pair<Class<T>, Schema>)lastSchema.get();
        if (cachedSchema != null && cachedSchema.fst() == type) {
            return (Schema)cachedSchema.snd();
        }
        Schema schema = XML.generateSchema(type);
        cachedSchema = Pair.make(type, schema);
        lastSchema = new WeakReference<Pair<Class<T>, Schema>>(cachedSchema);
        return schema;
    }

    public static <T> Schema generateSchema(Class<T> type) {
        return XML.generateSchema(type.getCanonicalName(), XML.getContext(type));
    }

    public static <T> Schema generateSchema(String schemaDescription, JAXBContext context) {
        try {
            final ArrayList schemas = new ArrayList();
            context.generateSchema(new SchemaOutputResolver(){

                public Result createOutput(String namespaceUri, String suggestedFileName) {
                    DOMResult schema = new DOMResult();
                    schema.setSystemId(suggestedFileName);
                    schemas.add(schema);
                    return schema;
                }
            });
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Source[] schemaSources = new DOMSource[schemas.size()];
            for (int i = 0; i < schemaSources.length; ++i) {
                schemaSources[i] = new DOMSource(((DOMResult)schemas.get(i)).getNode());
            }
            return factory.newSchema(schemaSources);
        }
        catch (IOException e) {
            throw new ResourceError("Failed to generate schema for " + schemaDescription, e);
        }
        catch (SAXException e) {
            throw new CatastrophicError("Failed to create schema for " + schemaDescription, e);
        }
    }

    public static <T> T read(Class<T> type, String sourceName, Reader reader) {
        return XML.read(XML.getSchema(type), type, sourceName, reader);
    }

    public static <T> T read(Class<T> type, File file) {
        return XML.read(XML.getSchema(type), type, file);
    }

    public static <T> T read(Schema schema, Class<T> type, File file) {
        try {
            return XML.read(schema, type, file.getAbsolutePath(), (Reader)new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new ResourceError("Couldn't read " + file.getAbsolutePath() + ".", e);
        }
    }

    public static <T> T read(Schema schema, Class<T> type, String sourceName, StreamSource source) {
        try {
            Unmarshaller unmarshaller = XML.getContext(type).createUnmarshaller();
            unmarshaller.setSchema(schema);
            return (T)unmarshaller.unmarshal((Source)source, type).getValue();
        }
        catch (UnmarshalException e) {
            throw new UserError(XML.getMessage(sourceName, (JAXBException)((Object)e)), e);
        }
        catch (JAXBException e) {
            throw new CatastrophicError("Couldn't create JAXB context for " + type.getCanonicalName(), e);
        }
    }

    public static <T> T read(Schema schema, Class<T> type, String sourceName, Reader reader) {
        return XML.read(schema, type, sourceName, new StreamSource(reader));
    }

    public static <T> T read(Class<T> type, String sourceName, InputStream inStream) {
        return XML.read(XML.getSchema(type), type, sourceName, new StreamSource(inStream));
    }

    public static Object read(Schema schema, JAXBContext context, String sourceName, Reader reader) {
        try {
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setSchema(schema);
            return unmarshaller.unmarshal((Source)new StreamSource(reader));
        }
        catch (UnmarshalException e) {
            throw new UserError(XML.getMessage(sourceName, (JAXBException)((Object)e)), e);
        }
        catch (JAXBException e) {
            throw new CatastrophicError("Couldn't create JAXB context from " + sourceName, e);
        }
    }

    private static String getMessage(String sourceName, JAXBException e) {
        StringBuilder msg = new StringBuilder("Malformed XML document in ").append(sourceName).append(":\n");
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            String message = cause.getMessage();
            if (message == null || message.length() <= 0) continue;
            msg.append("\t- ").append(message).append("\n");
        }
        return msg.toString();
    }

    public static <T> void write(Class<T> type, T toWrite, Writer writer) {
        XML.write(type, XML.getSchema(type), toWrite, writer);
    }

    public static <T> void write(Class<T> type, Schema schema, T toWrite, Writer writer) {
        StreamResult streamResult = new StreamResult(writer);
        XML.write(type, schema, toWrite, streamResult);
    }

    public static <T> void write(Class<T> type, T toWrite, OutputStream outStream) {
        StreamResult streamResult = new StreamResult(outStream);
        XML.write(type, XML.getSchema(type), toWrite, streamResult);
    }

    private static <T> void write(Class<T> type, Schema schema, T toWrite, StreamResult streamResult) {
        try {
            Marshaller marshaller = XML.getContext(type).createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setSchema(schema);
            marshaller.marshal(toWrite, (Result)streamResult);
        }
        catch (JAXBException e) {
            throw new UserError(XML.getMessage("", e), e);
        }
    }

    public static Schema parseSchema(URL url) {
        try {
            return new CompactSyntaxSchemaFactory().newSchema(url);
        }
        catch (SAXException e) {
            throw new ResourceError("Failed to parse schema", e);
        }
    }

    public static Schema parseSchema(File f) {
        try {
            return new CompactSyntaxSchemaFactory().newSchema(f);
        }
        catch (SAXException e) {
            throw new ResourceError("Failed to parse schema", e);
        }
    }

    public static Schema relaxngSchemaFromResource(Class<?> clazz, String resourceName) {
        URL url = clazz.getResource(resourceName);
        if (url == null) {
            throw new ResourceError("Could not find schema " + resourceName);
        }
        return XML.parseSchema(url);
    }

    public static List<String> validationErrors(Schema schema, final File xmlFile) {
        final ArrayList<String> result = new ArrayList<String>();
        if (!xmlFile.exists()) {
            result.add(xmlFile + ": file does not exist");
            return result;
        }
        Validator validator = schema.newValidator();
        validator.setResourceResolver(new AlwaysEmptyResolver());
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException error) {
                result.add(XML.oneLineSummary(error, xmlFile));
            }

            @Override
            public void fatalError(SAXParseException error) {
                result.add(XML.oneLineSummary(error, xmlFile));
            }

            @Override
            public void warning(SAXParseException arg0) {
            }
        });
        try {
            validator.validate(new StreamSource(xmlFile));
        }
        catch (SAXException e) {
            Exceptions.ignore(e, "SAX errors are handled via an error handler");
        }
        catch (IOException e) {
            throw new ResourceError("Error reading XML file '" + xmlFile + "'", e);
        }
        return result;
    }

    public static <T> boolean isValidDocument(File xmlFile, Class<T> type) {
        return XML.validationErrors(XML.getSchema(type), xmlFile).isEmpty();
    }

    public static String oneLineSummary(SAXParseException ex, File xmlFile) {
        StringBuilder message = new StringBuilder();
        message.append(xmlFile);
        message.append(":");
        message.append(ex.getLineNumber());
        message.append(":");
        message.append(ex.getColumnNumber());
        message.append(": ");
        message.append(ex.getMessage());
        return message.toString();
    }
}

