/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeql;

import com.github.codeql.DbLocation_default;
import com.github.codeql.ExtractorContext;
import com.github.codeql.KotlinExtractorDbSchemeKt;
import com.github.codeql.Label;
import com.github.codeql.LogCounter;
import com.github.codeql.LogMessage;
import com.github.codeql.Severity;
import com.github.codeql.StringLabel;
import com.github.codeql.TrapWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018JN\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0018\b\u0002\u0010\u001e\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060!j\u0002`\"0 0\u001fJV\u0010#\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0018\b\u0002\u0010\u001e\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060!j\u0002`\"0 0\u001fH\u0002J \u0010&\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u0018J\u0006\u0010'\u001a\u00020\u0013J\n\u0010(\u001a\u0004\u0018\u00010\u0018H\u0002J\u0016\u0010)\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010*\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u000bJ\u0016\u0010-\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J \u0010.\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u0018R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/github/codeql/LoggerBase;", "", "logCounter", "Lcom/github/codeql/LogCounter;", "(Lcom/github/codeql/LogCounter;)V", "extractorContextStack", "Ljava/util/Stack;", "Lcom/github/codeql/ExtractorContext;", "getExtractorContextStack", "()Ljava/util/Stack;", "file_number", "", "file_number_diagnostic_number", "getLogCounter", "()Lcom/github/codeql/LogCounter;", "logStream", "Ljava/io/Writer;", "verbosity", "close", "", "debug", "tw", "Lcom/github/codeql/TrapWriter;", "msg", "", "diagnostic", "severity", "Lcom/github/codeql/Severity;", "extraInfo", "locationString", "mkLocationId", "Lkotlin/Function0;", "Lcom/github/codeql/Label;", "Lcom/github/codeql/DbLocation_default;", "Lcom/github/codeql/DbLocation;", "emitDiagnostic", "diagnosticLocStr", "fullMsg", "error", "flush", "getDiagnosticLocation", "info", "printLimitedDiagnosticCounts", "setFileNumber", "index", "trace", "warn", "codeql-kotlin-extractor"})
public class LoggerBase {
    @NotNull
    private final LogCounter logCounter;
    @NotNull
    private final Stack<ExtractorContext> extractorContextStack;
    private final int verbosity;
    @NotNull
    private final Writer logStream;
    private int file_number;
    private int file_number_diagnostic_number;

    public LoggerBase(@NotNull LogCounter logCounter) {
        Intrinsics.checkNotNullParameter((Object)logCounter, (String)"logCounter");
        this.logCounter = logCounter;
        this.extractorContextStack = new Stack();
        Object object = System.getenv("CODEQL_EXTRACTOR_KOTLIN_VERBOSITY");
        this.verbosity = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 3;
        String extractorLogDir = System.getenv("CODEQL_EXTRACTOR_JAVA_LOG_DIR");
        if (extractorLogDir == null || Intrinsics.areEqual((Object)extractorLogDir, (Object)"")) {
            this.logStream = new OutputStreamWriter(System.out);
        } else {
            File logFile = File.createTempFile("kotlin-extractor.", ".log", new File(extractorLogDir));
            this.logStream = new FileWriter(logFile);
        }
        this.file_number = -1;
    }

    @NotNull
    public final LogCounter getLogCounter() {
        return this.logCounter;
    }

    @NotNull
    public final Stack<ExtractorContext> getExtractorContextStack() {
        return this.extractorContextStack;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private final String getDiagnosticLocation() {
        StackTraceElement[] st = new Exception().getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)st, (String)"st");
        StackTraceElement[] stackTraceElementArray = st;
        int n = 0;
        int n2 = stackTraceElementArray.length;
        while (n < n2) {
            StackTraceElement x = stackTraceElementArray[n];
            String string = x.getClassName();
            if (string == null) return x.toString();
            int n3 = -1;
            switch (string.hashCode()) {
                case 230208792: {
                    if (!string.equals("com.github.codeql.Logger")) break;
                    n3 = 1;
                    break;
                }
                case 1774707721: {
                    if (!string.equals("com.github.codeql.LoggerBase")) break;
                    n3 = 1;
                    break;
                }
                case -1454668364: {
                    if (!string.equals("com.github.codeql.FileLogger")) break;
                    n3 = 1;
                    break;
                }
            }
            switch (n3) {
                default: {
                    return x.toString();
                }
                case 1: 
            }
            ++n;
        }
        return null;
    }

    public final void setFileNumber(int index) {
        this.file_number = index;
        this.file_number_diagnostic_number = 0;
    }

    public final void diagnostic(@NotNull TrapWriter tw, @NotNull Severity severity, @NotNull String msg, @Nullable String extraInfo, @Nullable String locationString, @NotNull Function0<? extends Label<DbLocation_default>> mkLocationId2) {
        String string;
        String diagnosticLocStr;
        Intrinsics.checkNotNullParameter((Object)tw, (String)"tw");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter(mkLocationId2, (String)"mkLocationId");
        String diagnosticLoc = this.getDiagnosticLocation();
        String string2 = diagnosticLoc;
        if (string2 == null) {
            string2 = diagnosticLocStr = "<unknown location>";
        }
        if (diagnosticLoc == null) {
            string = "    Missing caller information.\n";
        } else {
            Pair<Severity, Integer> oldInfo = this.logCounter.getDiagnosticInfo().getOrDefault(diagnosticLoc, (Pair<Severity, Integer>)new Pair((Object)severity, (Object)0));
            if (severity != oldInfo.getFirst() && this.verbosity >= 1) {
                String message = "Severity mismatch (" + (Object)((Object)severity) + " vs " + oldInfo.getFirst() + ") at " + diagnosticLoc;
                LoggerBase.emitDiagnostic$default(this, tw, Severity.Error, "Inconsistency", message, message, null, null, 96, null);
            }
            int newCount = ((Number)oldInfo.getSecond()).intValue() + 1;
            Pair newInfo = new Pair((Object)severity, (Object)newCount);
            this.logCounter.getDiagnosticInfo().put(diagnosticLoc, (Pair<Severity, Integer>)newInfo);
            if (this.logCounter.getDiagnosticLimit() <= 0) {
                string = "";
            } else if (newCount == this.logCounter.getDiagnosticLimit()) {
                string = "    Limit reached for diagnostics from " + diagnosticLoc + ".\n";
            } else {
                if (newCount > this.logCounter.getDiagnosticLimit()) {
                    return;
                }
                string = "";
            }
        }
        String suffix = string;
        StringBuilder fullMsgBuilder = new StringBuilder();
        fullMsgBuilder.append(msg);
        if (extraInfo != null) {
            fullMsgBuilder.append('\n');
            fullMsgBuilder.append(extraInfo);
        }
        ListIterator listIterator = this.extractorContextStack.listIterator(this.extractorContextStack.size());
        Intrinsics.checkNotNullExpressionValue(listIterator, (String)"extractorContextStack.li\u2026tractorContextStack.size)");
        ListIterator iter = listIterator;
        while (iter.hasPrevious()) {
            ExtractorContext x = (ExtractorContext)iter.previous();
            fullMsgBuilder.append("  ...while extracting a " + x.getKind() + " (" + x.getName() + ") at " + x.getLoc() + '\n');
        }
        fullMsgBuilder.append(suffix);
        String string3 = fullMsgBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fullMsgBuilder.toString()");
        String fullMsg = string3;
        this.emitDiagnostic(tw, severity, diagnosticLocStr, msg, fullMsg, locationString, mkLocationId2);
    }

    public static /* synthetic */ void diagnostic$default(LoggerBase loggerBase, TrapWriter trapWriter, Severity severity, String string, String string2, String string3, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: diagnostic");
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            function0 = (Function0)new Function0<Label<DbLocation_default>>(trapWriter){
                final /* synthetic */ TrapWriter $tw;
                {
                    this.$tw = $tw;
                    super(0);
                }

                @NotNull
                public final Label<DbLocation_default> invoke() {
                    return this.$tw.getUnknownLocation();
                }
            };
        }
        loggerBase.diagnostic(trapWriter, severity, string, string2, string3, (Function0<? extends Label<DbLocation_default>>)function0);
    }

    private final void emitDiagnostic(TrapWriter tw, Severity severity, String diagnosticLocStr, String msg, String fullMsg, String locationString, Function0<? extends Label<DbLocation_default>> mkLocationId2) {
        String locStr = locationString == null ? "" : "At " + locationString + ": ";
        String kind = severity.compareTo((Enum)Severity.WarnHigh) <= 0 ? "WARN" : "ERROR";
        LogMessage logMessage = new LogMessage(kind, "Diagnostic(" + diagnosticLocStr + "): " + locStr + fullMsg);
        Label locationId = (Label)mkLocationId2.invoke();
        Label diagLabel = tw.getFreshIdLabel();
        KotlinExtractorDbSchemeKt.writeDiagnostics(tw, diagLabel, "CodeQL Kotlin extractor", severity.getSev(), "", msg, logMessage.getTimestamp() + ' ' + fullMsg, locationId);
        int n = this.file_number_diagnostic_number;
        this.file_number_diagnostic_number = n + 1;
        KotlinExtractorDbSchemeKt.writeDiagnostic_for(tw, diagLabel, new StringLabel("compilation"), this.file_number, n);
        this.logStream.write(logMessage.toJsonLine());
    }

    static /* synthetic */ void emitDiagnostic$default(LoggerBase loggerBase, TrapWriter trapWriter, Severity severity, String string, String string2, String string3, String string4, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: emitDiagnostic");
        }
        if ((n & 0x20) != 0) {
            string4 = null;
        }
        if ((n & 0x40) != 0) {
            function0 = (Function0)new Function0<Label<DbLocation_default>>(trapWriter){
                final /* synthetic */ TrapWriter $tw;
                {
                    this.$tw = $tw;
                    super(0);
                }

                @NotNull
                public final Label<DbLocation_default> invoke() {
                    return this.$tw.getUnknownLocation();
                }
            };
        }
        loggerBase.emitDiagnostic(trapWriter, severity, string, string2, string3, string4, (Function0<? extends Label<DbLocation_default>>)function0);
    }

    public final void trace(@NotNull TrapWriter tw, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tw, (String)"tw");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.verbosity >= 4) {
            LogMessage logMessage = new LogMessage("TRACE", msg);
            tw.writeComment(logMessage.toText());
            this.logStream.write(logMessage.toJsonLine());
        }
    }

    public final void debug(@NotNull TrapWriter tw, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tw, (String)"tw");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.verbosity >= 4) {
            LogMessage logMessage = new LogMessage("DEBUG", msg);
            tw.writeComment(logMessage.toText());
            this.logStream.write(logMessage.toJsonLine());
        }
    }

    public final void info(@NotNull TrapWriter tw, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tw, (String)"tw");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.verbosity >= 3) {
            LogMessage logMessage = new LogMessage("INFO", msg);
            tw.writeComment(logMessage.toText());
            this.logStream.write(logMessage.toJsonLine());
        }
    }

    public final void warn(@NotNull TrapWriter tw, @NotNull String msg, @Nullable String extraInfo) {
        Intrinsics.checkNotNullParameter((Object)tw, (String)"tw");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.verbosity >= 2) {
            LoggerBase.diagnostic$default(this, tw, Severity.Warn, msg, extraInfo, null, null, 48, null);
        }
    }

    public final void error(@NotNull TrapWriter tw, @NotNull String msg, @Nullable String extraInfo) {
        Intrinsics.checkNotNullParameter((Object)tw, (String)"tw");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.verbosity >= 1) {
            LoggerBase.diagnostic$default(this, tw, Severity.Error, msg, extraInfo, null, null, 48, null);
        }
    }

    public final void printLimitedDiagnosticCounts(@NotNull TrapWriter tw) {
        Intrinsics.checkNotNullParameter((Object)tw, (String)"tw");
        for (Map.Entry<String, Pair<Severity, Integer>> entry : this.logCounter.getDiagnosticInfo().entrySet()) {
            String caller = entry.getKey();
            Pair<Severity, Integer> info = entry.getValue();
            Severity severity = (Severity)((Object)info.getFirst());
            int count = ((Number)info.getSecond()).intValue();
            if (count < this.logCounter.getDiagnosticLimit()) continue;
            String message = "Total of " + count + " diagnostics (reached limit of " + this.logCounter.getDiagnosticLimit() + ") from " + caller + '.';
            if (this.verbosity < 1) continue;
            LoggerBase.emitDiagnostic$default(this, tw, severity, "Limit", message, message, null, null, 96, null);
        }
    }

    public final void flush() {
        this.logStream.flush();
    }

    public final void close() {
        this.logStream.close();
    }
}

