/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.exception;

import com.semmle.util.exception.NestedError;
import java.util.Arrays;

public class CatastrophicError
extends NestedError {
    private static final long serialVersionUID = 4132771414092814913L;

    public CatastrophicError(String string) {
        super(string);
    }

    public CatastrophicError(Throwable throwable) {
        super(throwable);
    }

    public CatastrophicError(String string, Throwable throwable) {
        super(string, throwable);
    }

    public static void throwIf(boolean bl, String string) {
        if (bl) {
            throw new CatastrophicError(string);
        }
    }

    public static void throwIfNull(Object object) {
        if (object == null) {
            throw new CatastrophicError("null object");
        }
    }

    public static void throwIfNull(Object object, String string) {
        if (object == null) {
            throw new CatastrophicError(string);
        }
    }

    public static void throwIfAnyNull(Object ... objectArray) {
        String[] stringArray = null;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            stringArray = stringArray == null ? new String[1] : Arrays.copyOf(stringArray, stringArray.length + 1);
            stringArray[stringArray.length - 1] = "" + i;
        }
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray.length == 0) {
                stringBuffer.append("null argument(s)");
            } else {
                stringBuffer.append("null argument" + (stringArray.length > 1 ? "s: " : ": ") + stringArray[0]);
                for (int i = 1; i < stringArray.length; ++i) {
                    stringBuffer.append(", " + stringArray[i]);
                }
            }
            String string = stringBuffer.toString();
            throw new CatastrophicError(string);
        }
    }

    public static <T> T nonNull(T t) {
        CatastrophicError.throwIfNull(t);
        return t;
    }
}

