/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.files;

import com.github.codeql.Logger;
import com.semmle.util.basic.ObjectUtil;
import com.semmle.util.data.Pair;
import com.semmle.util.data.StringUtil;
import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.exception.Exceptions;
import com.semmle.util.exception.ResourceError;
import com.semmle.util.files.PathMatcher;
import com.semmle.util.io.StreamUtil;
import com.semmle.util.io.csv.CSVReader;
import com.semmle.util.io.csv.CSVWriter;
import com.semmle.util.process.Env;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessControlException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;

public class FileUtil {
    public static Logger logger;
    private static final Pattern rpInvalidFilenameCharacters;
    public static final Charset UTF8;
    private static final BitSet allowedCharacters;
    public static final FileFilter falseFilter;
    private static final Pattern ANY_PATH_SEPARATOR;
    private static final int FILE_OPERATION_ATTEMPTS_LIMIT = 30;
    private static final int FILE_OPERATION_ATTEMPTS_DELAY_MS = 1000;

    public static File[] list(File file) {
        return FileUtil.list(file, null);
    }

    public static File[] list(File file, FileFilter fileFilter) {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = fileFilter == null ? file.listFiles() : file.listFiles(fileFilter);
        if (objectArray == null) {
            boolean bl = file.exists();
            boolean bl2 = file.isDirectory();
            boolean bl3 = file.canRead();
            throw new ResourceError("Could not list the contents of directory " + file + " - " + (!bl ? "file does not exist." : (!bl2 ? "file is not a directory." : (!bl3 ? "cannot read - permission denied." : "unknown I/O error."))));
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    @Deprecated
    public static Set<File> recursiveFind(File file, FileFilter fileFilter) {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        FileUtil.recursiveFind(file, fileFilter, linkedHashSet);
        return linkedHashSet;
    }

    @Deprecated
    public static Set<File> recursiveFind(File file, FileFilter fileFilter, FileFilter fileFilter2) {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        FileUtil.recursiveFind(file, fileFilter, fileFilter2, linkedHashSet);
        return linkedHashSet;
    }

    @Deprecated
    public static void recursiveFind(File file, FileFilter fileFilter, Set<File> set) {
        FileUtil.recursiveFind(file, fileFilter, null, set);
    }

    @Deprecated
    public static void recursiveFind(File file, FileFilter fileFilter, FileFilter fileFilter2, Set<File> set) {
        for (File file2 : FileUtil.list(file, fileFilter)) {
            set.add(file2);
        }
        FileFilter fileFilter3 = fileFilter2 == null ? FileUtil.kindFilter(false) : FileUtil.andFilters(FileUtil.kindFilter(false), fileFilter2);
        for (File file3 : FileUtil.list(file, fileFilter3)) {
            FileUtil.recursiveFind(file3, fileFilter, fileFilter2, set);
        }
    }

    public static void mkdirs(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                return;
            }
            throw new ResourceError("Can't create " + file + " -- it exists as a non-directory.");
        }
        if (file.mkdirs()) {
            return;
        }
        if (file.isDirectory()) {
            return;
        }
        File file2 = file;
        File file3 = file.getParentFile();
        while (file3 != null) {
            if (file3.exists()) {
                throw new ResourceError("Couldn't create child directory " + file2.getName() + " of " + (file3.isDirectory() ? "" : "non-directory ") + file3 + ".");
            }
            file2 = file3;
            file3 = file2.getParentFile();
        }
        throw new ResourceError("Couldn't create " + file.getPath() + ": no ancestor even exists.");
    }

    public static boolean isAbsolute(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.charAt(0) == '/' || string.charAt(0) == '\\' || string.length() >= 3 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':' && (string.charAt(2) == '/' || string.charAt(2) == '\\');
    }

    public static boolean copy(File file, File file2) {
        boolean bl = file2.exists();
        try {
            FileUtil.copyFile(file, file2, false);
            return true;
        }
        catch (IOException iOException) {
            if (!bl) {
                file2.delete();
            }
            logger.error("Cannot copy " + file + " to " + file2, iOException);
            return false;
        }
    }

    public static boolean append(File file, File file2) {
        try {
            FileUtil.copyFile(file, file2, true);
            return true;
        }
        catch (IOException iOException) {
            logger.error("Cannot append contents of " + file + " to " + file2, iOException);
            return false;
        }
    }

    public static void write(File file, String string) {
        Writer writer = null;
        try {
            writer = FileUtil.openWriterUTF8(file, true, false);
            writer.write(string);
        }
        catch (IOException iOException) {
            try {
                throw new ResourceError("Failed to write to file " + file, iOException);
            }
            catch (Throwable throwable) {
                FileUtil.close(writer);
                throw throwable;
            }
        }
        FileUtil.close(writer);
    }

    public static void append(File file, String string) {
        Writer writer = null;
        try {
            writer = FileUtil.openWriterUTF8(file, false, true);
            writer.write(string);
        }
        catch (IOException iOException) {
            try {
                throw new ResourceError("Failed to append to file " + file, iOException);
            }
            catch (Throwable throwable) {
                FileUtil.close(writer);
                throw throwable;
            }
        }
        FileUtil.close(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(File file) throws IOException {
        char[] cArray = new char[10240];
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF8");){
            int n = inputStreamReader.read(cArray);
            while (n > 0) {
                stringBuilder.append(cArray, 0, n);
                n = inputStreamReader.read(cArray);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(Path path) throws IOException {
        char[] cArray = new char[10240];
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), "UTF8");){
            int n = inputStreamReader.read(cArray);
            while (n > 0) {
                stringBuilder.append(cArray, 0, n);
                n = inputStreamReader.read(cArray);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Properties loadProperties(File file) {
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Properties properties2;
            try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(fileInputStream), UTF8);){
                properties.load(inputStreamReader);
                properties2 = properties;
            }
            return properties2;
        }
        catch (IOException iOException) {
            throw new ResourceError("Failed to read properties from " + file, iOException);
        }
    }

    public static void writeProperties(Properties properties, File file) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fileOutputStream), UTF8);){
            properties.store(outputStreamWriter, null);
        }
        catch (IOException iOException) {
            throw new ResourceError("Failed to write properties to " + file, iOException);
        }
    }

    @Deprecated
    public static boolean recursiveCopy(File file, File file2, final FileFilter fileFilter) {
        FileFilter fileFilter2 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (fileFilter == null || file.isDirectory()) {
                    return true;
                }
                return fileFilter == null || fileFilter.accept(file);
            }
        };
        return FileUtil.strictRecursiveCopy(file, file2, fileFilter2);
    }

    @Deprecated
    public static boolean strictRecursiveCopy(File file, File file2, FileFilter fileFilter) {
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return FileUtil.copy(file, file2);
        }
        if (!file2.exists() && !file2.mkdir()) {
            return false;
        }
        boolean bl = true;
        for (File file3 : FileUtil.list(file, fileFilter)) {
            File file4 = new File(file2, file3.getName());
            bl &= FileUtil.strictRecursiveCopy(file3, file4, fileFilter);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeStreamToFile(InputStream inputStream, File file) {
        if (inputStream == null) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[16384];
            while ((n = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            logger.error("Error writing stream to file", iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.ignore(iOException, "We don't care about exceptions during closing");
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.ignore(iOException, "We don't care about exceptions during closing");
                }
            }
        }
        return true;
    }

    public static void writeStreamToFile(InputStream inputStream, Path path) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            StreamUtil.copy(inputStream, outputStream);
        }
    }

    public static InputStream getFileInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.trace("Could not open file for input stream", fileNotFoundException);
            return null;
        }
    }

    private static void copyFile(File file, File file2, boolean bl) throws IOException {
        if ((file = FileUtil.tryMakeCanonical(file)).equals(file2 = FileUtil.tryMakeCanonical(file2))) {
            if (bl) {
                throw new IOException("Trying to append the contents of file " + file + " onto itself");
            }
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            if (!file2.exists()) {
                file2.createNewFile();
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(file2, bl);
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                int n;
                byte[] byArray = new byte[16384];
                while ((n = ((InputStream)bufferedInputStream).read(byArray)) > 0) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                }
            }
        }
        file2.setExecutable(FileUtil.canExecute(file));
    }

    private static boolean canExecute(File file) {
        try {
            return file.canExecute();
        }
        catch (AccessControlException accessControlException) {
            if (accessControlException.getPermission() instanceof FilePermission && ((FilePermission)accessControlException.getPermission()).getActions().contains("execute")) {
                return false;
            }
            throw accessControlException;
        }
    }

    public static final String sanitizeFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!allowedCharacters.get(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static final File createUniqueFile(File file, String string) {
        return FileUtil.createUniqueFileImpl(file, string, false);
    }

    public static final File createUniqueDirectory(File file, String string) {
        return FileUtil.createUniqueFileImpl(file, string, true);
    }

    private static final File createUniqueFileImpl(File file, String string, boolean bl) {
        String string2;
        if (!file.exists()) {
            throw new IllegalArgumentException("FileUtil.makeUniqueName(" + file + ",\"" + string + "\"):  directory " + file + " does not exist.");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("FileUtil.makeUniqueName(" + file + ",\"" + string + "\"):  file " + file + " is not a directory.");
        }
        if (string.contains("/")) {
            throw new IllegalArgumentException("FileUtil.makeUniqueName(" + file + ",\"" + string + "\"):  file name \"" + string + "\" is not a simple file name.");
        }
        String string3 = string2 = (string = FileUtil.replaceInvalidFilenameChars(string));
        File file2 = new File(file, string3);
        String string4 = FileUtil.extension(new File(string2));
        int n = 1;
        try {
            while (!(!bl ? file2.createNewFile() : file2.mkdir())) {
                string3 = string4.length() > 0 ? string2.substring(0, string2.length() - string4.length()) + "-" + n + string4 : string2 + "-" + n;
                file2 = new File(file, string3);
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new ResourceError("Failed to create a unique file in " + file, iOException);
        }
        return file2;
    }

    public static boolean containsInvalidFilenameChars(String string) {
        return rpInvalidFilenameCharacters.matcher(string).find();
    }

    public static String replaceInvalidFilenameChars(String string) {
        return rpInvalidFilenameCharacters.matcher(string).replaceAll("_");
    }

    public static final File appendToName(File file, int n) {
        String string = file.getPath();
        String string2 = FileUtil.extension(file);
        string = string2.length() > 0 ? string.substring(0, string.length() - string2.length()) + "-" + n + string2 : string + "-" + n;
        return new File(string);
    }

    public static String extension(File file) {
        return FileUtil.extension(file.getName());
    }

    public static String extension(Path path) {
        return FileUtil.extension(path.getFileName().toString());
    }

    public static String extension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        String string2 = string.substring(n);
        if (string2.equals(".gz") || string2.equals(".br")) {
            int n2 = string.lastIndexOf(46, n - 1);
            if (n2 == -1) {
                return string2;
            }
            String string3 = string.substring(n2);
            return string3;
        }
        if (string2.equals(".zip") && string.endsWith(".xml.zip")) {
            return ".xml.zip";
        }
        return string2;
    }

    public static String basename(File file) {
        return FileUtil.stripExtension(file.getName());
    }

    public static String basename(Path path) {
        Path path2 = path.getFileName();
        return path2 == null ? "" : FileUtil.stripExtension(path2.toString());
    }

    public static String stripExtension(String string) {
        return string.substring(0, string.length() - FileUtil.extension(string).length());
    }

    public static File withExtension(File file, String string) {
        return new File(FileUtil.withExtension(file.getPath(), string));
    }

    public static String withExtension(String string, String string2) {
        String string3 = FileUtil.extension(string);
        return string.substring(0, string.length() - string3.length()) + string2;
    }

    public static FileFilter nameFilter(boolean bl, String ... stringArray) {
        return new FileFilterImpl(stringArray, bl, false);
    }

    public static FileFilter antlikeFilter(File file, boolean bl, String ... stringArray) {
        return new PatternFilter(file, PathMatcher.Mode.Ant, bl, stringArray);
    }

    public static FileFilter regexNameFilter(String string, boolean bl) {
        return new RegexFileFilter(Pattern.compile(string), bl);
    }

    public static FileFilter extensionFilter(boolean bl, String ... stringArray) {
        return new FileFilterImpl(stringArray, bl, true);
    }

    public static boolean containsAny(File file, FileFilter fileFilter) {
        if (!file.isDirectory()) {
            return false;
        }
        Stack<File> stack = new Stack<File>();
        stack.push(file);
        while (!stack.isEmpty()) {
            File file2 = (File)stack.pop();
            for (File file3 : FileUtil.list(file2)) {
                if (fileFilter.accept(file3)) {
                    return true;
                }
                if (!file2.isDirectory()) continue;
                stack.push(file3);
            }
        }
        return false;
    }

    public static FileFilter kindFilter(final boolean bl) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile() && bl) {
                    return true;
                }
                return file.isDirectory() && !bl;
            }
        };
    }

    public static FileFilter setFilter(final Set<File> set) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return set.contains(file);
            }
        };
    }

    public static FileFilter negateFilter(final FileFilter fileFilter) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !fileFilter.accept(file);
            }
        };
    }

    public static FileFilter andFilters(final FileFilter ... fileFilterArray) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                for (FileFilter fileFilter : fileFilterArray) {
                    if (fileFilter.accept(file)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private static String sanitizePathString(String string) {
        string = string.replace(':', '_');
        string = string.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        return string;
    }

    public static File appendAbsolutePath(File file, String string) {
        string = FileUtil.sanitizePathString(string);
        return new File(file, string).getAbsoluteFile();
    }

    public static Path appendAbsolutePath(Path path, String string) {
        Path path2 = Paths.get(string = FileUtil.sanitizePathString(string), new String[0]);
        if (path2.getRoot() != null) {
            path2 = path2.getRoot().relativize(path2);
        }
        return path.resolve(path2);
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                Exceptions.ignore(iOException, "Contract is to ignore");
            }
            catch (UndeclaredThrowableException undeclaredThrowableException) {
                if (undeclaredThrowableException.getCause() instanceof IOException) {
                    Exceptions.ignore(undeclaredThrowableException, "Undeclared exception was an IOException, ignoring");
                }
                throw undeclaredThrowableException;
            }
        }
    }

    public static void close(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                Exceptions.ignore(iOException, "Contract is to ignore");
            }
        }
    }

    public static ResolvedCompressedSourceArchivePaths resolveCompressedSourceArchivePaths(File file, String string) {
        String string2;
        String string3 = "";
        boolean bl = file.getName().equals("src_archive.zip");
        if (bl) {
            string3 = FileUtil.convertPathForSourceArchiveZip("");
            string2 = string3 + string;
        } else {
            string2 = string.startsWith("/") ? string.substring(1) : string;
        }
        return new ResolvedCompressedSourceArchivePaths(string3, string2);
    }

    public static String convertAbsolutePathForSourceArchive(String string) {
        if (string == null) {
            throw new CatastrophicError("FileUtil.convertPathForSourceArchiveZip: absolutePath must be non-null");
        }
        string = FileUtil.normalisePath(string);
        if (!(string = string.replace(':', '_')).startsWith("/")) {
            string = "/" + string;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String convertPathForSourceArchiveZip(String string) {
        return "src_archive" + FileUtil.convertAbsolutePathForSourceArchive(string);
    }

    public static File fileRelativeTo(File file, String string) {
        if (!FileUtil.isRelativePath(string)) {
            throw new CatastrophicError("Invalid relative path '" + string + "'.");
        }
        return new File(file, string);
    }

    public static boolean isRelativePath(String string) {
        if (string.startsWith("/")) {
            return false;
        }
        if (string.startsWith("\\")) {
            return false;
        }
        return Env.getOS() != Env.OS.WINDOWS || !string.contains(":");
    }

    public static String normalisePath(String string) {
        char c;
        if (string == null) {
            throw new CatastrophicError("FileUtil.normalisePath: path must be non-null");
        }
        if (string.length() >= 2 && string.charAt(1) == ':' && (c = string.charAt(0)) >= 'a' && c <= 'z') {
            string = Character.toUpperCase(c) + string.substring(1);
        }
        string = string.replace('\\', '/');
        return string;
    }

    public static File commonParent(File file, File file2) {
        File file3;
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (file3 = file; file3 != null; file3 = file3.getParentFile()) {
            linkedHashSet.add(file3);
        }
        for (file3 = file2; file3 != null; file3 = file3.getParentFile()) {
            if (linkedHashSet.add(file3)) continue;
            return file3;
        }
        throw new ResourceError("Could not determine a common parent for " + file + " and " + file2 + ".");
    }

    public static File commonParent(List<File> list) {
        if (list.isEmpty()) {
            throw new CatastrophicError("No files to find common parent of");
        }
        File file = list.get(0);
        for (File file2 : list) {
            file = FileUtil.commonParent(file, file2);
        }
        return file;
    }

    public static String relativePath(File file, File file2) {
        String string = FileUtil.relativePathOpt(file, file2);
        if (string != null) {
            return string;
        }
        throw new ResourceError("Could not determine a relative path to " + file + " from " + file2);
    }

    public static String tryMakeRelativePath(File file, File file2) {
        String string = FileUtil.relativePathOpt(file, file2);
        return string != null ? string : file.getAbsolutePath();
    }

    public static String relativePathOpt(File file, File file2) {
        Object object;
        try {
            object = file.getCanonicalFile();
            File file3 = file2.getCanonicalFile();
            String string = FileUtil.relativePathAsIsOpt((File)object, file3);
            if (string != null) {
                return string;
            }
        }
        catch (IOException iOException) {
            Exceptions.ignore(iOException, "Fall through to comparing standard paths");
        }
        object = FileUtil.relativePathAsIsOpt(file, file2);
        return object;
    }

    public static String relativePathAsIsOpt(File file, File file2) {
        String string = file.getPath();
        String string2 = file2.getPath();
        int n = string2.length();
        if (string.length() <= n) {
            return null;
        }
        if (!string.startsWith(string2)) {
            return null;
        }
        if (string.charAt(n) == File.separatorChar) {
            return string.substring(n + 1);
        }
        if (n > 0 && string.charAt(n - 1) == File.separatorChar) {
            return string.substring(n);
        }
        return null;
    }

    public static boolean isWithin(File file, File file2) {
        return FileUtil.relativePathOpt(file, file2) != null || FileUtil.tryMakeCanonical(file).equals(FileUtil.tryMakeCanonical(file2));
    }

    public static String relativePathLink(File file, File file2) {
        file = file.getAbsoluteFile();
        file2 = file2.getAbsoluteFile();
        File file3 = FileUtil.commonParent(file, file2);
        StringBuilder stringBuilder = new StringBuilder();
        File file4 = file2;
        while (!file4.equals(file3)) {
            stringBuilder.append(".." + File.separator);
            file4 = file4.getParentFile();
        }
        stringBuilder.append(FileUtil.relativePath(file, file3));
        return stringBuilder.toString();
    }

    public static File tryMakeCanonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            Exceptions.ignore(iOException, "Can't log error: Could be too verbose.");
            return new File(FileUtil.simplifyPath(file));
        }
    }

    public static boolean recursiveParentOf(File file, File file2) {
        return FileUtil.relativePathOpt(file2, file) != null;
    }

    @Deprecated
    public static boolean recursiveDelete(File file) {
        return FileUtil.recursiveDelete(file, falseFilter) == DeletionResult.Deleted;
    }

    @Deprecated
    public static DeletionResult recursiveDelete(File file, FileFilter fileFilter) {
        if (fileFilter.accept(file)) {
            return DeletionResult.SkippedSomeFiles;
        }
        if (file.delete()) {
            return DeletionResult.Deleted;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return DeletionResult.Failed;
            }
            boolean bl = false;
            for (File file2 : fileArray) {
                DeletionResult deletionResult = FileUtil.recursiveDelete(file2, fileFilter);
                if (deletionResult == DeletionResult.Failed) {
                    return DeletionResult.Failed;
                }
                if (deletionResult != DeletionResult.SkippedSomeFiles) continue;
                bl = true;
            }
            if (file.delete()) {
                return DeletionResult.Deleted;
            }
            return bl ? DeletionResult.SkippedSomeFiles : DeletionResult.Failed;
        }
        return DeletionResult.Failed;
    }

    public static File replaceFileExtension(File file, String string) {
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        return new File(file.getParentFile(), string2 + string);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sha1(File file) {
        String string;
        byte[] byArray = new byte[4096];
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            while ((n = fileInputStream.read(byArray)) > 0) {
                messageDigest.update(byArray, 0, n);
            }
            string = StringUtil.toHex(messageDigest.digest());
        }
        catch (IOException iOException) {
            try {
                throw new ResourceError("Could not read file for hashing: " + file, iOException);
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new ResourceError("Could not find SHA-1 algorithm", noSuchAlgorithmException);
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(fileInputStream);
                throw throwable;
            }
        }
        FileUtil.close(fileInputStream);
        return string;
    }

    public static void copyPropertiesFile(File file, File file2, Set<Pair<String, String>> set, String string) {
        if (file.isFile()) {
            FileUtil.copy(file, file2);
        }
        FileUtil.appendProperties(file2, set, string);
    }

    public static void appendProperties(File file, Set<Pair<String, String>> set, String string) {
        if (set.isEmpty()) {
            return;
        }
        Properties properties = new Properties();
        for (Pair<String, String> pair : set) {
            properties.put(pair.fst(), pair.snd());
        }
        StringWriter stringWriter = new StringWriter();
        stringWriter.append('\n');
        try {
            properties.store(stringWriter, string);
        }
        catch (IOException iOException) {
            throw new ResourceError("Failed to convert properties to string while appending to file " + file, iOException);
        }
        FileUtil.append(file, stringWriter.toString());
    }

    public static void appendProperties(File file, Map<String, String> map, String string) {
        LinkedHashSet<Pair<String, String>> linkedHashSet = new LinkedHashSet<Pair<String, String>>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            linkedHashSet.add(Pair.make(entry.getKey(), entry.getValue()));
        }
        FileUtil.appendProperties(file, linkedHashSet, string);
    }

    public static String normalizePathSeparators(String string) {
        return ANY_PATH_SEPARATOR.matcher(string).replaceAll("/");
    }

    public static String simplifyPath(File file) {
        return file.toPath().toAbsolutePath().normalize().toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> readPropertiesCSV(File file) {
        Map map;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        InputStreamReader inputStreamReader = null;
        FileInputStream fileInputStream = null;
        CSVReader cSVReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            cSVReader = new CSVReader(inputStreamReader);
            for (String[] stringArray : cSVReader.readAll()) {
                if (stringArray.length < 1) continue;
                String string = stringArray[0];
                String string2 = null;
                if (stringArray.length >= 2) {
                    string2 = stringArray[1];
                }
                linkedHashMap.put(string, string2);
            }
            map = Collections.unmodifiableMap(linkedHashMap);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                throw new CatastrophicError(unsupportedEncodingException);
                catch (IOException iOException) {
                    throw new ResourceError("Could not read data from " + file, iOException);
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(inputStreamReader);
                FileUtil.close(fileInputStream);
                FileUtil.close(cSVReader);
                throw throwable;
            }
        }
        FileUtil.close(inputStreamReader);
        FileUtil.close(fileInputStream);
        FileUtil.close(cSVReader);
        return map;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writePropertiesCSV(File file, Map<String, String> map) throws IOException {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        CSVWriter cSVWriter = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            cSVWriter = new CSVWriter(outputStreamWriter);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                cSVWriter.writeNext(entry.getKey(), entry.getValue());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new ResourceError("Could not find file '" + file + "'", fileNotFoundException);
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new CatastrophicError(unsupportedEncodingException);
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(cSVWriter);
                FileUtil.close(outputStreamWriter);
                FileUtil.close(fileOutputStream);
                throw throwable;
            }
        }
        FileUtil.close(cSVWriter);
        FileUtil.close(outputStreamWriter);
        FileUtil.close(fileOutputStream);
    }

    public static final File ensureUnique(File file) {
        try {
            if (file.exists()) {
                File file2;
                Random random = new Random();
                while ((file2 = new File(file.toString() + "." + random.nextInt())).exists()) {
                }
                return file2;
            }
            return file;
        }
        catch (SecurityException securityException) {
            throw new ResourceError("Could not access file " + file, securityException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Writer openWriterUTF8(File file, boolean bl, boolean bl2) {
        try {
            FileOutputStream fileOutputStream;
            if (file.exists()) {
                if (bl2) {
                    fileOutputStream = new FileOutputStream(file, true);
                    return new OutputStreamWriter((OutputStream)fileOutputStream, UTF8);
                } else {
                    if (!bl) throw new ResourceError("File already exists: " + file);
                    if (!file.delete()) {
                        throw new ResourceError("Could not delete existing file: " + file);
                    }
                    fileOutputStream = new FileOutputStream(file, false);
                }
                return new OutputStreamWriter((OutputStream)fileOutputStream, UTF8);
            } else {
                fileOutputStream = new FileOutputStream(file, false);
            }
            return new OutputStreamWriter((OutputStream)fileOutputStream, UTF8);
        }
        catch (SecurityException securityException) {
            throw new ResourceError("Could not access file " + file, securityException);
        }
        catch (IOException iOException) {
            throw new ResourceError("Failed to open FileWriter for " + file, iOException);
        }
    }

    public static void forceRename(File file, File file2) {
        if (file == null) {
            throw new CatastrophicError("FileUtil.forceRename: source File is null.");
        }
        if (file2 == null) {
            throw new CatastrophicError("FileUtil.forceRename: destination File is null.");
        }
        if (!file.exists()) {
            throw new ResourceError("FileUtil.forceRename: source File '" + file.toString() + "' does not exist.");
        }
        FileUtil.mkdirs(file2.getAbsoluteFile().getParentFile());
        if (file2.exists() && !FileUtil.recursiveDelete(file2)) {
            throw new ResourceError("FileUtil.forceRename: Couldn't overwrite destination file '" + file2.toString() + "'.");
        }
        if (!file.renameTo(file2)) {
            throw new ResourceError("FileUtil.forceRename: Couldn't rename file '" + file.toString() + "' to '" + file2.toString() + "'.");
        }
    }

    public static void forceCopy(File file, File file2) {
        if (file == null) {
            throw new CatastrophicError("FileUtil.forceCopy: source File is null.");
        }
        if (file2 == null) {
            throw new CatastrophicError("FileUtil.forceCopy: destination File is null.");
        }
        if (!file.exists()) {
            throw new ResourceError("FileUtil.forceCopy: source File '" + file.toString() + "' does not exist.", new FileNotFoundException(file.toString()));
        }
        FileUtil.mkdirs(file2.getAbsoluteFile().getParentFile());
        if (file2.exists() && !FileUtil.recursiveDelete(file2)) {
            throw new ResourceError("FileUtil.forceCopy: Couldn't overwrite destination file '" + file2.toString() + "'.");
        }
        if (!FileUtil.copy(file, file2)) {
            throw new ResourceError("FileUtil.forceCopy: Couldn't copy file '" + file.toString() + "' to '" + file2.toString() + "'.");
        }
    }

    public static boolean isReadableFile(File file) {
        return file != null && file.isFile() && file.canRead();
    }

    public static boolean isSamePath(File file, File file2) {
        if (file == null || file2 == null) {
            return false;
        }
        return ObjectUtil.equals(FileUtil.tryMakeCanonical(file), FileUtil.tryMakeCanonical(file2));
    }

    public static File addExtension(File file, String string) {
        return new File(file.getPath() + "." + string);
    }

    public static void ensureFileExists(File file) {
        try {
            if (!file.exists()) {
                FileUtil.mkdirs(file.getAbsoluteFile().getParentFile());
                if (!file.createNewFile()) {
                    throw new ResourceError("Cannot create file '" + file + "', since a directory with the same name already exists!");
                }
            } else if (file.isDirectory()) {
                throw new ResourceError("Cannot create file '" + file + "', since a directory with the same name already exists!");
            }
        }
        catch (IOException iOException) {
            throw new ResourceError("Could not create file '" + file + "'", iOException);
        }
    }

    public static File createTempDir() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        return FileUtil.createUniqueDirectory(file, "semmleTempDir");
    }

    private static void performWithRetries(RetryablePathConsumer retryablePathConsumer, Path path, Path path2, ErrorMessageCreator errorMessageCreator) throws IOException {
        int n = 1;
        while (true) {
            try {
                retryablePathConsumer.accept(path, path2);
                return;
            }
            catch (AtomicMoveNotSupportedException atomicMoveNotSupportedException) {
                throw atomicMoveNotSupportedException;
            }
            catch (IOException iOException) {
                String string = errorMessageCreator.apply(path, path2);
                logger.warn(string + " (attempt " + n + ")", iOException);
                if (n == 30) {
                    throw new IOException(string + "(" + 30 + " attempts made)", iOException);
                }
                try {
                    logger.trace("Waiting for 1000 ms before making another attempt.");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.warn("Thread interrupted before making another attempt.", interruptedException);
                }
                ++n;
                continue;
            }
            break;
        }
    }

    public static void moveWithRetries(Path path, Path path2, final CopyOption ... copyOptionArray) throws IOException {
        FileUtil.performWithRetries(new RetryablePathConsumer(){

            @Override
            public void accept(Path path, Path path2) throws IOException {
                Files.move(path, path2, copyOptionArray);
            }
        }, path, path2, new ErrorMessageCreator(){

            @Override
            public String apply(Path path, Path path2) {
                return "Failed to perform move from " + path.toAbsolutePath() + " to " + path2.toAbsolutePath();
            }
        });
    }

    static {
        int n;
        logger = null;
        rpInvalidFilenameCharacters = Pattern.compile("[\\\\/:*?\"'<>|@]");
        UTF8 = Charset.forName("UTF-8");
        allowedCharacters = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            allowedCharacters.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            allowedCharacters.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            allowedCharacters.set(n);
        }
        allowedCharacters.set(45);
        allowedCharacters.set(95);
        allowedCharacters.set(32);
        allowedCharacters.set(91);
        allowedCharacters.set(93);
        falseFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return false;
            }
        };
        ANY_PATH_SEPARATOR = Pattern.compile("[\\\\/]+(\\.[\\\\/]+)*");
    }

    private static class FileFilterImpl
    implements FileFilter {
        private final String[] names;
        private final boolean caseSensitive;
        private final boolean extensionOnly;

        private FileFilterImpl(String[] stringArray, boolean bl, boolean bl2) {
            this.names = Arrays.copyOf(stringArray, stringArray.length);
            this.caseSensitive = bl;
            this.extensionOnly = bl2;
            if (!bl) {
                for (int i = 0; i < this.names.length; ++i) {
                    this.names[i] = StringUtil.lc(this.names[i]);
                }
            }
        }

        @Override
        public boolean accept(File file) {
            if (!file.isFile()) {
                return false;
            }
            String string = this.caseSensitive ? file.getName() : StringUtil.lc(file.getName());
            for (String string2 : this.names) {
                if (this.extensionOnly && string.endsWith(string2)) {
                    return true;
                }
                if (this.extensionOnly || !string.equals(string2)) continue;
                return true;
            }
            return false;
        }
    }

    private static class PatternFilter
    implements FileFilter {
        private final PathMatcher matcher;
        private final boolean exclude;
        private final File cwd;

        private PatternFilter(File file, PathMatcher.Mode mode, boolean bl, String ... stringArray) {
            this.cwd = file;
            this.exclude = bl;
            this.matcher = new PathMatcher(mode, Arrays.asList(stringArray));
        }

        @Override
        public boolean accept(File file) {
            String string = FileUtil.relativePathOpt(file, this.cwd);
            if (string == null) {
                return this.exclude;
            }
            return this.exclude ^ this.matcher.matches(string);
        }
    }

    private static class RegexFileFilter
    implements FileFilter {
        private final Pattern pattern;
        private final boolean matchFiles;

        private RegexFileFilter(Pattern pattern, boolean bl) {
            this.pattern = pattern;
            this.matchFiles = bl;
        }

        @Override
        public boolean accept(File file) {
            if (file.isFile() != this.matchFiles) {
                return false;
            }
            return this.pattern.matcher(file.getName()).matches();
        }
    }

    public static class ResolvedCompressedSourceArchivePaths {
        public final String srcArchivePath;
        public final String sourceLocationPrefix;

        public ResolvedCompressedSourceArchivePaths(String string, String string2) {
            this.srcArchivePath = string;
            this.sourceLocationPrefix = string2;
        }
    }

    public static enum DeletionResult {
        Deleted,
        SkippedSomeFiles,
        Failed;

    }

    private static interface RetryablePathConsumer {
        public void accept(Path var1, Path var2) throws IOException;
    }

    private static interface ErrorMessageCreator {
        public String apply(Path var1, Path var2);
    }
}

