/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io;

import com.semmle.util.files.FileUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;

public class BufferedLineReader
implements Closeable {
    private final char[] buffer = new char[8192];
    private int nextChar = 0;
    private int nChars = 0;
    private final Reader in;

    public BufferedLineReader(Reader reader) {
        this.in = reader;
    }

    public String readLineAndTerminator() throws IOException {
        int n = this.findNextLineTerminator();
        if (n == -1) {
            return null;
        }
        String string = new String(this.buffer, this.nextChar, n - this.nextChar + 1);
        this.nextChar = n + 1;
        return string;
    }

    private int findNextLineTerminator() throws IOException {
        int n;
        int n2 = 0;
        do {
            for (n = this.nextChar + n2; n < this.nChars; ++n) {
                if (this.buffer[n] == '\r' && n + 1 < this.nChars && this.buffer[n + 1] == '\n') {
                    return n + 1;
                }
                if (this.buffer[n] != '\n') continue;
                return n;
            }
            n2 = this.nChars - this.nextChar;
        } while ((n = this.fill()) > 0);
        return this.nChars - 1;
    }

    private int fill() throws IOException {
        int n;
        if (this.nextChar >= this.nChars) {
            this.nextChar = 0;
            this.nChars = 0;
        } else if (this.nextChar > 0) {
            System.arraycopy(this.buffer, this.nextChar, this.buffer, 0, this.nChars - this.nextChar);
            this.nChars -= this.nextChar;
            this.nextChar = 0;
        }
        if (this.nChars == this.buffer.length) {
            return 0;
        }
        while ((n = this.in.read(this.buffer, this.nChars, this.buffer.length - this.nChars)) == 0) {
        }
        if (n > 0) {
            this.nChars += n;
        }
        return n;
    }

    @Override
    public void close() {
        FileUtil.close(this.in);
    }
}

