/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.data;

import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.exception.Exceptions;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Pattern;

public class StringUtil {
    private static final Random RANDOM = new Random();
    private static final DecimalFormat DOUBLE_FORMATTER = new DecimalFormat("#.######", new DecimalFormatSymbols(Locale.ROOT));
    private static final List<Character> specialMarkdownChars;
    private static final Charset UTF8_CHARSET;
    private static final Pattern lineEnding;
    private static final Pattern lineEndingIncludingSeparators;
    private static final Pattern whitespace;
    private static final char[] HEX_CHARS;
    private static final Pattern DIGITS_PATTERN;
    public static final Pattern NEWLINE_PATTERN;

    public static String box(List<String> list) {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String object2 : list) {
            Object object = StringUtil.lines(object2);
            int n2 = ((String[])object).length;
            for (n = 0; n < n2; ++n) {
                Object object3 = object[n];
                arrayList.add(object3);
            }
        }
        int n3 = 0;
        for (Object object : arrayList) {
            n3 = Math.max(n3, ((String)object).length());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n3 + 6; ++i) {
            stringBuilder.append('*');
        }
        for (String string : arrayList) {
            stringBuilder.append("\n*  ");
            stringBuilder.append(string);
            for (n = 0; n < n3 - string.length(); ++n) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("  *");
        }
        stringBuilder.append('\n');
        for (int i = 0; i < n3 + 6; ++i) {
            stringBuilder.append('*');
        }
        return stringBuilder.toString();
    }

    public static String escapeStringLiteralForRegexp(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("(){}[].^$+\\*?".indexOf(c) != -1 && string2.indexOf(c) == -1) {
                stringBuilder.append("\\").append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String pad(int n, Padding padding, String string) {
        int n2 = string.length();
        int n3 = n - n2;
        if (n3 > 0) {
            int n4;
            int n5;
            int n6;
            switch (padding) {
                case LEFT: {
                    n6 = 0;
                    n5 = n3;
                    break;
                }
                case RIGHT: {
                    n6 = n3;
                    n5 = 0;
                    break;
                }
                case CENTRE: {
                    n6 = n3 / 2;
                    n5 = n3 - n6;
                    break;
                }
                default: {
                    throw new CatastrophicError("Unknown padding kind: " + (Object)((Object)padding));
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (n4 = 0; n4 < n6; ++n4) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
            for (n4 = 0; n4 < n5; ++n4) {
                stringBuilder.append(' ');
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public static List<String> pad(Padding padding, Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        int n = 0;
        for (String string : collection) {
            n = Math.max(n, string.length());
        }
        for (String string : collection) {
            arrayList.add(StringUtil.pad(n, padding, string));
        }
        return arrayList;
    }

    public static List<String> pad(Padding padding, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        int n = 0;
        for (String string : stringArray) {
            n = Math.max(n, string.length());
        }
        for (String string : stringArray) {
            arrayList.add(StringUtil.pad(n, padding, string));
        }
        return arrayList;
    }

    public static void padTable(List<String[]> list, Padding ... paddingArray) {
        int n;
        int n2 = paddingArray.length;
        int[] nArray = new int[n2];
        for (Object[] objectArray : list) {
            if (objectArray.length != n2) {
                throw new CatastrophicError("padTable can only be used with a rectangular table. Expected " + n2 + " columns but found row: " + Arrays.toString(objectArray));
            }
            for (n = 0; n < n2; ++n) {
                nArray[n] = Math.max(nArray[n], ((String)objectArray[n]).length());
            }
        }
        for (String[] stringArray : list) {
            for (n = 0; n < n2; ++n) {
                stringArray[n] = StringUtil.pad(nArray[n], paddingArray[n], stringArray[n]);
            }
        }
    }

    public static String glue(String string, Iterable<?> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Object obj : iterable) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append(obj == null ? "<null>" : obj.toString());
        }
        return stringBuilder.toString();
    }

    public static String glue(String string, Object[] objectArray) {
        return StringUtil.glue(string, Arrays.asList(objectArray));
    }

    public static String glue(String string, String ... stringArray) {
        return StringUtil.glue(string, (Object[])stringArray);
    }

    public static String escapePropertiesValue(String string) {
        return string.replace("!", "\\!").replace(":", "\\:").replace("#", "\\#").replace("=", "\\=").replace("\n", "\\n");
    }

    public static String escapePropertiesKey(String string) {
        return StringUtil.escapePropertiesValue(string).replace(" ", "\\ ");
    }

    public static String printFloat(double d) {
        if (Math.abs(d) > 9.99999999999999E14 && !Double.isInfinite(d)) {
            return DOUBLE_FORMATTER.format(new BigDecimal(d));
        }
        return DOUBLE_FORMATTER.format(d);
    }

    public static String escapeHTML(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n * 2 > 0 ? n * 2 : n);
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&#39;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String escapeJSON(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block9: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block9;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        stringBuilder.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String escapeMarkdown(String string) {
        return StringUtil.escapeMarkdown(specialMarkdownChars, string);
    }

    public static String escapeMarkdown(List<Character> list, String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (list.contains(Character.valueOf(c)) && (c != '#' || bl)) {
                stringBuilder.append("\\").append(c);
            } else {
                stringBuilder.append(c);
            }
            bl = c != '&';
        }
        return stringBuilder.toString();
    }

    public static String makeQLStringLiteral(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        block7: for (char c : string.toCharArray()) {
            switch (c) {
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block7;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public static String wrap(String string, int n) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                if (n2 < 0) {
                    arrayList.add("");
                } else {
                    arrayList.add(string.substring(n2, i).trim());
                }
                n2 = -1;
                n3 = -1;
                n4 = 0;
            } else if (Character.isWhitespace(string.charAt(i))) {
                if (n4 > n) {
                    if (n2 < 0) continue;
                    if (n3 < 0) {
                        String string2 = string.substring(n2, i).trim();
                        if (string2.length() > 0) {
                            arrayList.add(string2);
                        }
                        n2 = -1;
                    } else if (n3 > n2) {
                        arrayList.add(string.substring(n2, n3 - 1).trim());
                        n2 = n3;
                        n4 = i - n2 + 1;
                        n3 = -1;
                    } else {
                        arrayList.add(string.substring(n3, i).trim());
                        n2 = -1;
                        n3 = -1;
                    }
                } else {
                    n3 = -1;
                }
            } else {
                if (n2 < 0) {
                    n2 = i;
                    n4 = 0;
                }
                if (n3 < 0) {
                    n3 = i;
                }
            }
            if (n2 < 0) continue;
            ++n4;
        }
        if (n2 > -1) {
            arrayList.add(string.substring(n2).trim());
        }
        return StringUtil.glue("\n", arrayList);
    }

    public static String firstWord(String string) {
        int n;
        string = string.trim();
        for (n = 0; n < string.length() && !Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return string.substring(0, n);
    }

    public static String stripFirstWord(String string) {
        int n;
        string = string.trim();
        for (n = 0; n < string.length() && !Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return string.substring(n).trim();
    }

    public static String trim(String string, char c) {
        return StringUtil.trim(string, c, true, true);
    }

    public static String trim(String string, char c, boolean bl, boolean bl2) {
        int n;
        int n2 = string.length();
        if (bl) {
            for (n = 0; n < n2 && string.charAt(n) == c; ++n) {
            }
        }
        if (bl2) {
            while (n < n2 && string.charAt(n2 - 1) == c) {
                --n2;
            }
        }
        if (n > 0 || n2 < string.length()) {
            string = string.substring(n, n2);
        }
        return string;
    }

    public static String trimTrailingWhitespace(String string) {
        int n;
        int n2 = 0;
        for (n = string.length(); n2 < n && Character.isWhitespace(string.charAt(n - 1)); --n) {
        }
        if (n < string.length()) {
            string = string.substring(n2, n);
        }
        return string;
    }

    public static String bytesToString(byte[] byArray) {
        return new String(byArray, 0, byArray.length, UTF8_CHARSET);
    }

    public static String bytesToString(byte[] byArray, int n, int n2) {
        return new String(byArray, n, n2, UTF8_CHARSET);
    }

    public static byte[] stringToBytes(String string) {
        return string.getBytes(Charset.forName("UTF-8"));
    }

    public static byte[] stringToSHA1(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            return messageDigest.digest(StringUtil.stringToBytes(string));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CatastrophicError("Failed to obtain MessageDigest for computing SHA-1", noSuchAlgorithmException);
        }
    }

    public static String repeat(String string, int n) {
        if (n == 0) {
            return "";
        }
        return new String(new char[n]).replace("\u0000", string);
    }

    public static String lc(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    public static String uc(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static String ucfirst(String string) {
        if (string.isEmpty() || !Character.isLowerCase(string.charAt(0))) {
            return string;
        }
        return StringUtil.uc(string.substring(0, 1)) + string.substring(1);
    }

    public static String[] lines(String string) {
        return StringUtil.lines(string, false, true);
    }

    public static String[] linesWithSeparators(String string) {
        return StringUtil.lines(string, true, true);
    }

    public static String[] lines(String string, boolean bl) {
        return StringUtil.lines(string, false, bl);
    }

    public static String[] lines(String string, boolean bl, boolean bl2) {
        if (string.length() == 0) {
            return new String[0];
        }
        Pattern pattern = bl ? lineEndingIncludingSeparators : lineEnding;
        return pattern.split(string, bl2 ? 0 : -1);
    }

    public static String toUnixLineEndings(String string) {
        return lineEnding.matcher(string).replaceAll("\n");
    }

    public static boolean isMultiLine(String string) {
        return lineEnding.matcher(string).find();
    }

    public static String[] words(String string) {
        if ((string = string.trim()).length() == 0) {
            return new String[0];
        }
        return whitespace.split(string);
    }

    public static String[] paragraphs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string2 : StringUtil.lines(string)) {
            if (string2.isEmpty()) {
                if (!bl) {
                    arrayList.add(stringBuilder.toString());
                }
                stringBuilder = new StringBuilder();
                bl = true;
                continue;
            }
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string2);
            bl = false;
        }
        if (!bl) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[0]);
    }

    public static String toHex(byte ... byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        char[] cArray = HEX_CHARS;
        for (byte by : byArray) {
            stringBuilder.append(cArray[by >>> 4 & 0xF]).append(cArray[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static byte[] fromHex(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            throw new NumberFormatException("Hexadecimal string should have an even number of characters.");
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            int n3 = Character.digit(string.charAt(i), 16);
            if (n3 == -1) {
                throw new NumberFormatException("Invalid character in hexadecimal string: " + string.charAt(i));
            }
            int n4 = Character.digit(string.charAt(i + 1), 16);
            if (n4 == -1) {
                throw new NumberFormatException("Invalid character in hexadecimal string: " + string.charAt(i + 1));
            }
            byArray[n2] = (byte)(n3 << 4 | n4);
            ++n2;
        }
        return byArray;
    }

    public static String getDurationString(long l) {
        char c = l < 0L ? (char)'-' : '+';
        long l2 = l = l < 0L ? -l : l;
        if ((double)l < 10000.0) {
            return c + StringUtil.getDurationString(l, 1.0, "[ns]");
        }
        if ((double)l < 1.0E7) {
            return c + StringUtil.getDurationString(l, 1000.0, "[us]");
        }
        if ((double)l < 1.0E10) {
            return c + StringUtil.getDurationString(l, 1000000.0, "[ms]");
        }
        if ((double)l < 1.0E13) {
            return c + StringUtil.getDurationString(l, 1.0E9, "[s] ");
        }
        if ((double)l < 6.0E14) {
            return c + StringUtil.getDurationString(l, 6.0E10, "[m] ");
        }
        if ((double)l < 3.6E16) {
            return c + StringUtil.getDurationString(l, 3.6E12, "[h] ");
        }
        if ((double)l < 8.64E17) {
            return c + StringUtil.getDurationString(l, 8.64E13, "[d] ");
        }
        return c + StringUtil.getDurationString(l, 3.1536E16, "[y] ");
    }

    private static String getDurationString(long l, double d, String string) {
        String string2 = String.format("%-4f", (double)l / d).substring(0, 4);
        return (string2.endsWith(".") ? string2.replace(".", " ") : string2) + string;
    }

    public static Integer parseInteger(String string) {
        if (string == null) {
            return null;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Exceptions.ignore(numberFormatException, "deliberate test");
            return null;
        }
    }

    public static StringBuilder appendLine(StringBuilder stringBuilder, Object ... objectArray) {
        for (Object object : objectArray) {
            stringBuilder.append(object);
        }
        return stringBuilder.append("\n");
    }

    public static String prefixLines(String string, String string2) {
        return string2.replaceAll("(?m)^", string);
    }

    public static int count(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    public static String addLineNumbers(String string) {
        String[] stringArray = StringUtil.lines(string, false);
        int n = Integer.toString(stringArray.length).length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = i == stringArray.length - 1;
            stringBuilder.append(String.format("%" + n + "s  %s" + (bl ? "" : "\n"), i + 1, stringArray[i]));
        }
        return stringBuilder.toString();
    }

    public static boolean isDigits(String string) {
        return DIGITS_PATTERN.matcher(string).matches();
    }

    public static boolean isAsciiLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean secureIsEqual(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        byte[] byArray = StringUtil.stringToBytes(string);
        boolean bl = string2 == null || string2.length() != string.length();
        byte[] byArray2 = StringUtil.stringToBytes(bl ? string : string2);
        byte[] byArray3 = new byte[string.length()];
        RANDOM.nextBytes(byArray3);
        if (bl) {
            byArray2 = byArray3;
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n |= byArray[i] ^ byArray2[i];
        }
        return n == 0 && !bl;
    }

    public static String lineSeparator() {
        return System.getProperty("line.separator");
    }

    public static <T> String naturalGlue(String string, String string2, Collection<T> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<T> iterator = collection.iterator();
        boolean bl = true;
        if (iterator.hasNext()) {
            boolean bl2 = true;
            T t = iterator.next();
            while (bl2) {
                Object var8_8;
                bl2 = iterator.hasNext();
                Object v0 = var8_8 = iterator.hasNext() ? iterator.next() : null;
                if (bl) {
                    bl = false;
                } else if (!bl2) {
                    stringBuilder.append(string2);
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(t != null ? t : "<null>");
                t = var8_8;
            }
        }
        return stringBuilder.toString();
    }

    public static String camelToSpinal(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != string2.charAt(n)) {
                if (n > 0) {
                    stringBuilder.append("-");
                }
                int n2 = 0;
                while (n < string.length() && string.charAt(n) != string2.charAt(n)) {
                    if (n2 > 0 && n + 1 < string.length() && string.charAt(n + 1) == string2.charAt(n + 1) && StringUtil.isAsciiLetter(string2.charAt(n + 1))) {
                        stringBuilder.append("-").append(string2.charAt(n++));
                        break;
                    }
                    stringBuilder.append(string2.charAt(n++));
                    ++n2;
                }
            }
            while (n < string.length() && string.charAt(n) == string2.charAt(n)) {
                stringBuilder.append(string2.charAt(n++));
            }
        }
        return stringBuilder.toString();
    }

    public static String lowerCaseFirstLetter(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    public static String stripQlCommentsAndStrings(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < string.length(); ++i) {
            if (!bl3 && !bl4 && StringUtil.matchesAt(string, i, "\"") && !StringUtil.isEscaped(string, i)) {
                bl2 = !bl2;
                continue;
            }
            if (StringUtil.matchesEolAt(string, i)) {
                if (bl) {
                    bl2 = false;
                } else if (bl2) {
                    throw new IllegalArgumentException("Unterminated string found.");
                }
            }
            if (!bl2 && !bl3 && StringUtil.matchesAt(string, i, "//")) {
                bl4 = true;
                continue;
            }
            if (bl4 && StringUtil.matchesEolAt(string, i)) {
                bl4 = false;
            }
            if (!bl2 && !bl4 && StringUtil.matchesAt(string, i, "/*")) {
                bl3 = true;
            } else if (bl3 && StringUtil.matchesAt(string, i, "*/")) {
                bl3 = false;
                ++i;
                continue;
            }
            if (bl2 || bl3 || bl4) continue;
            stringBuilder.append(string.charAt(i));
        }
        if (bl2 && !bl) {
            throw new IllegalArgumentException("Unterminated string found.");
        }
        return stringBuilder.toString();
    }

    public static String stripQlCommentsAndStrings(String string) {
        return StringUtil.stripQlCommentsAndStrings(string, false);
    }

    private static boolean matchesAt(String string, int n, String string2) {
        if (n + string2.length() > string.length()) {
            return false;
        }
        return string.substring(n, n + string2.length()).equals(string2);
    }

    private static boolean matchesEolAt(String string, int n) {
        return StringUtil.matchesOneOfAt(string, n, "\n", "\r");
    }

    private static boolean matchesOneOfAt(String string, int n, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!StringUtil.matchesAt(string, n, string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEscaped(String string, int n) {
        if (n == 0) {
            return false;
        }
        return StringUtil.previousCharacter(string, n) == '\\' && !StringUtil.isEscaped(string, n - 1);
    }

    private static char previousCharacter(String string, int n) {
        if (n == 0) {
            return '\u0000';
        }
        return string.charAt(n - 1);
    }

    public static boolean arrayEqualsIgnoreCase(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2 == null;
        }
        if (stringArray2 == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if ((stringArray[i] != null || stringArray2[i] == null) && stringArray[i].equalsIgnoreCase(stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static String toCommentString(String string) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/**\n");
        for (String string2 : stringArray = StringUtil.lines(string)) {
            stringBuilder.append(" *" + string2);
            stringBuilder.append("\n");
        }
        stringBuilder.append(" */");
        return stringBuilder.toString();
    }

    public static boolean isPrintableAscii(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (StringUtil.isPrintableAscii(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintableAscii(char c) {
        return c >= ' ' && c < '\u007f';
    }

    public static boolean isAsciiText(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (StringUtil.isAsciiText(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAsciiText(char c) {
        return StringUtil.isPrintableAscii(c) || c == '\t' || c == '\n' || c == '\r';
    }

    public static boolean containsControlCharacters(String string) {
        for (char c : string.toCharArray()) {
            if (!StringUtil.isControlCharacter(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isControlCharacter(char c) {
        if (c > '\u009f') {
            return false;
        }
        if (c >= ' ' && c < '\u007f') {
            return false;
        }
        return c != '\t' && c != '\n' && c != '\r';
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = DOUBLE_FORMATTER.getDecimalFormatSymbols();
        decimalFormatSymbols.setNaN("NaN");
        decimalFormatSymbols.setInfinity("Infinity");
        DOUBLE_FORMATTER.setDecimalFormatSymbols(decimalFormatSymbols);
        specialMarkdownChars = Arrays.asList(Character.valueOf('\\'), Character.valueOf('`'), Character.valueOf('_'), Character.valueOf('*'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('#'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('!'));
        UTF8_CHARSET = Charset.forName("UTF-8");
        lineEnding = Pattern.compile("\r\n|\r|\n");
        lineEndingIncludingSeparators = Pattern.compile("(?<=(\r\n|\r(?!\n)|\n))");
        whitespace = Pattern.compile("\\s+");
        HEX_CHARS = "0123456789abcdef".toCharArray();
        DIGITS_PATTERN = Pattern.compile("[0-9]+");
        NEWLINE_PATTERN = Pattern.compile("\n");
    }

    public static enum Padding {
        LEFT,
        RIGHT,
        CENTRE;

    }
}

