package com.semmle.util.version;

import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SemanticVersion extends SemanticVersion {

  private final int majorVersion;

  private final int minorVersion;

  private final int patchVersion;

  private final Optional<String> prereleaseVersion;

  private final Optional<String> buildMetadata;

  AutoValue_SemanticVersion(
      int majorVersion,
      int minorVersion,
      int patchVersion,
      Optional<String> prereleaseVersion,
      Optional<String> buildMetadata) {
    this.majorVersion = majorVersion;
    this.minorVersion = minorVersion;
    this.patchVersion = patchVersion;
    if (prereleaseVersion == null) {
      throw new NullPointerException("Null prereleaseVersion");
    }
    this.prereleaseVersion = prereleaseVersion;
    if (buildMetadata == null) {
      throw new NullPointerException("Null buildMetadata");
    }
    this.buildMetadata = buildMetadata;
  }

  @Override
  public int getMajorVersion() {
    return majorVersion;
  }

  @Override
  public int getMinorVersion() {
    return minorVersion;
  }

  @Override
  public int getPatchVersion() {
    return patchVersion;
  }

  @Override
  public Optional<String> getPrereleaseVersion() {
    return prereleaseVersion;
  }

  @Override
  public Optional<String> getBuildMetadata() {
    return buildMetadata;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SemanticVersion) {
      SemanticVersion that = (SemanticVersion) o;
      return this.majorVersion == that.getMajorVersion()
          && this.minorVersion == that.getMinorVersion()
          && this.patchVersion == that.getPatchVersion()
          && this.prereleaseVersion.equals(that.getPrereleaseVersion())
          && this.buildMetadata.equals(that.getBuildMetadata());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= majorVersion;
    h$ *= 1000003;
    h$ ^= minorVersion;
    h$ *= 1000003;
    h$ ^= patchVersion;
    h$ *= 1000003;
    h$ ^= prereleaseVersion.hashCode();
    h$ *= 1000003;
    h$ ^= buildMetadata.hashCode();
    return h$;
  }

}
