
__author__ = 'Guido van Rossum <guido@python.org>'
__all__ = ['load_grammar']
import os
import logging
import pkgutil
import sys
from . import grammar, pgen
if (sys.version < '3'):
    from cStringIO import StringIO
else:
    from io import StringIO

def load_grammar(package, grammar):
    data = pkgutil.get_data(package, grammar)
    stream = StringIO(data.decode('utf8'))
    g = pgen.generate_grammar(grammar, stream)
    return g
