
from __future__ import print_function, division
import sys
import logging
import os
import os.path
import re
from packaging.specifiers import SpecifierSet
from packaging.version import Version
import buildtools.semmle.requirements as requirements
logging.basicConfig(level=logging.WARNING)

def pip_install(req, venv, dependencies=True, wheel=True):
    venv.upgrade_pip()
    tmp = requirements.save_to_file([req])
    args = ['install', '-r', tmp]
    if dependencies:
        print(('Installing %s with dependencies.' % req))
    elif wheel:
        print(('Installing %s without dependencies.' % req))
        args += ['--no-deps']
    else:
        print(('Installing %s without dependencies or wheel.' % req))
        args += ['--no-deps', '--no-binary', ':all:']
    print(('Calling ' + ' '.join(args)))
    venv.pip(args)
    os.remove(tmp)

def restrict_django(reqs):
    for req in reqs:
        if ((sys.version_info[0] < 3) and (req.name.lower() == 'django')):
            if (Version('2') in req.specifier):
                req.specifier = SpecifierSet('<2')
    return reqs
ignored_packages = ['pyobjc-.*', 'pypiwin32', 'frida', 'pyopenssl', 'wxpython', 'cryptography', 'psycopg2']
if (os.name != 'nt'):
    ignored_packages.append('pywin32')
ignored_package_regex = re.compile('|'.join(ignored_packages))

def non_ignored(reqs):
    filtered_reqs = []
    for req in reqs:
        if (ignored_package_regex.match(req.name.lower()) is not None):
            logging.info(('Package %s is ignored. Skipping.' % req.name))
        else:
            filtered_reqs += [req]
    return filtered_reqs

def try_install_with_deps(req, venv):
    try:
        pip_install(req, venv, dependencies=True)
    except Exception as ex:
        logging.warn(('Failed to install all dependencies for ' + req.name))
        logging.info(ex)
        try:
            pip_install(req, venv, dependencies=False)
        except Exception:
            pip_install(req, venv, dependencies=False, wheel=False)

def install(reqs, venv):
    if isinstance(reqs, str):
        reqs = reqs.split('\n')
    reqs = requirements.parse(reqs)
    reqs = restrict_django(reqs)
    reqs = non_ignored(reqs)
    cleaned = requirements.clean(reqs)
    restricted = requirements.restrict(reqs)
    for (i, req) in enumerate(restricted):
        try:
            try_install_with_deps(req, venv)
        except Exception as ex1:
            try:
                try_install_with_deps(cleaned[i], venv)
            except Exception as ex2:
                logging.error(('Failed to install ' + req.name))
                logging.warning(ex2)
                return False
            logging.info(('Failed to install restricted form of ' + req.name))
            logging.info(ex1)
    return True
