
import sys
from semmle import util
from semmle.python.passes.objects import ObjectPass
from semmle.extractors.base import BaseExtractor
SkippedBuiltin = object()

class BuiltinExtractor(BaseExtractor):
    name = 'built-in extractor'

    def process(self, unit):
        if ((not self.options.extract_stdlib) and isinstance(unit, util.FileExtractable) and unit.path.startswith(util.STDLIB_PATH)):
            return SkippedBuiltin
        if (not isinstance(unit, util.BuiltinModuleExtractable)):
            return NotImplemented
        name = util.unicode_to_str(unit.name, sys.getfilesystemencoding())
        try:
            module = __import__(name)
        except ImportError as e:
            if e.path.endswith('.so'):
                return NotImplemented
            else:
                raise e
        writer = util.TrapWriter()
        ObjectPass().extract_builtin(module, writer)
        output = writer.get_compressed()
        self.trap_folder.write_trap('builtin', name, output)
        return ()

    def close(self):
        pass
