
from . import stub_gen
import re
import marshal
from semmle.python import extractor
from semmle import util
from semmle.python.modules import PythonSourceModule
PROTBUF_REGEX = re.compile('.*_pb2\\.py$')

class ProtobufExtractor(object):
    name = 'protobuf extractor'

    def __init__(self, options, trap_folder, src_archive, logger):
        self.trap_folder = trap_folder
        self.src_archive = src_archive
        self.module_extractor = extractor.Extractor.from_options(options, trap_folder, src_archive, logger)
        self.logger = logger
        self.extractor_path = options.path

    def process(self, unit):
        if (not isinstance(unit, util.FileExtractable)):
            return NotImplemented
        if (not PROTBUF_REGEX.match(unit.path)):
            return NotImplemented
        if unit.path.endswith('.pyc'):
            with open(unit.path, 'rb') as bytecode:
                _unused_magic = bytecode.read(4)
                _unused_date = bytecode.read(4)
                code = marshal.load(bytecode)
        else:
            with open(unit.path, 'rbU') as orig_src:
                code = orig_src.read()
        src = stub_gen.stub_source(code, self.extractor_path)
        bytes_source = src.encode('utf-8')
        module = PythonSourceModule(None, unit.path, self.logger, byte_source=bytes_source)
        assert isinstance(module._source, unicode)
        self.module_extractor.process_source_module(module)
        return ()

    def close(self):
        self.module_extractor.close()
