
from semmle.python import ast
from blib2to3.pgen2.token import NAME
from collections import deque

def add_token(mapping, index, token):
    if (token[1] not in mapping):
        mapping[token[1]] = deque()
    mapping[token[1]].append((index, token))

def find_matches(pyxl, python):
    offsets = (0, 0)
    all_names = set(pyxl.keys()).union(python.keys())
    while True:
        score = float('inf')
        match = None
        for name in all_names:
            try:
                index_sum = (pyxl[name][0][0] + python[name][0][0])
                if (index_sum < score):
                    score = index_sum
                    match = name
            except (IndexError, KeyError):
                pass
        if (match is None):
            return
        pyxl_match = pyxl[match][0]
        python_match = python[match][0]
        (yield (pyxl_match[1], python_match[1]))
        pyxl_index = pyxl_match[0]
        python_index = python_match[0]
        for token_list in python.values():
            while (token_list and (token_list[0][0] <= python_index)):
                token_list.popleft()
        for token_list in pyxl.values():
            while (token_list and (token_list[0][0] <= pyxl_index)):
                token_list.popleft()

def make_location_mapping(pyxl_tokens, py_tokens):
    pyxl = {}
    python = {}
    matched_location = {}
    for (index, token) in enumerate(pyxl_tokens):
        if (token[0] == NAME):
            add_token(pyxl, index, token)
    for (index, token) in enumerate(py_tokens):
        if (token[0] == NAME):
            add_token(python, index, token)
    for (pyxl_token, python_token) in find_matches(pyxl, python):
        matched_location[python_token[2]] = pyxl_token[2]
        matched_location[python_token[3]] = pyxl_token[3]
    return matched_location

def relocate(the_ast, pyxl_tokens, py_tokens):
    location_mapping = make_location_mapping(pyxl_tokens, py_tokens)

    def change_locations(node):
        if hasattr(node, 'lineno'):
            start = (node.lineno, node.col_offset)
            if (start in location_mapping):
                (node.lineno, node.col_offset) = location_mapping[start]
        if hasattr(node, '_end'):
            if (node._end in location_mapping):
                node._end = location_mapping[node._end]
        for (field, value) in ast.iter_fields(node):
            if isinstance(value, list):
                for item in value:
                    if isinstance(item, ast.AstBase):
                        change_locations(item)
            elif isinstance(value, ast.AstBase):
                change_locations(value)
    change_locations(the_ast)
