
from __future__ import absolute_import
from semmle.extractors.py_extractor import PythonExtractor
from semmle.extractors.pyxl.relocator import relocate

def token_list(lines):
    from pyxl.codec.tokenizer import pyxl_tokenize
    it = iter(lines)

    def readline():
        return next(it)
    return list(pyxl_tokenize(readline))

class PyxlExtractor(PythonExtractor):

    def process(self, unit):
        (py_module, imports) = self._get_module_and_imports(unit)
        if (py_module is None):
            return NotImplemented
        if (py_module.encoding == 'pyxl'):
            _pyxl_tokens = token_list(py_module.bytes_source.decode('utf8').splitlines(True))
            relocate(py_module.ast, _pyxl_tokens, py_module.tokens)
        self.module_extractor.process_source_module(py_module)
        return imports
