
import os
import re

def escape(pattern):
    ESCAPE = '(){}[].^$+\\?|'

    def escape_char(char):
        if (char in ESCAPE):
            return ('\\' + char)
        else:
            return char
    return ''.join((escape_char(c) for c in pattern))
SEP = escape(os.sep)
STAR_STAR_REGEX = ('([^%s]*%s)*' % (SEP, SEP))
STAR_REGEX = ('[^%s]*' % SEP)

def validate_pattern(pattern):
    (kind, glob) = pattern.split(':')
    if (not (kind in ('include', 'exclude'))):
        raise SyntaxError(("Illegal type: '%s'" % kind))
    parts = glob.split('/')
    for p in parts:
        if (('**' in p) and (p != '**')):
            raise SyntaxError(("Illegal path element: '%s'" % p))

def glob_part_to_regex(glob, add_sep):
    if (glob == '**'):
        return STAR_STAR_REGEX
    if ('*' in glob):
        pattern = glob.replace('*', STAR_REGEX)
    else:
        pattern = glob
    if add_sep:
        return (pattern + SEP)
    else:
        return pattern

def glob_to_regex(glob, prefix=''):
    glob = glob.strip().strip('/')
    parts = glob.split('/')
    if (parts[(- 1)] == '**'):
        parts = parts[:(- 1)]
        if (not parts):
            return '.*'
    parts = ([glob_part_to_regex(escape(p), True) for p in parts[:(- 1)]] + [glob_part_to_regex(escape(parts[(- 1)]), False)])
    full_pattern = ((((escape(prefix) + ''.join(parts)) + '(?:') + SEP) + '.*|$)')
    return re.compile(full_pattern)

def filter_from_pattern(pattern, prev_filter, prefix):
    validate_pattern(pattern)
    (kind, glob) = pattern.strip().split(':')
    result = (kind == 'include')
    regex = glob_to_regex(glob, prefix)

    def filter(path):
        if regex.match(path):
            return result
        return prev_filter(path)
    return filter
