
grammar = '\nstart           :  document\ndocument        :  header* definition*\nheader          :  include | cppinclude | namespace\ninclude         :  "include" LITERAL\ncppinclude      :  "cpp_include" LITERAL\nnamespace       :  ( "namespace" ( namespacescope name )\n                |                ( "smalltalk.prefix" name ) )\n                |  ( "php_namespace" LITERAL )\n                |  ( "xsd_namespace" LITERAL )\n!namespacescope :  "*" | IDENTIFIER\ndefinition      :  const | typedef | enum | senum | struct | union | exception | service\nconst           :  "const" fieldtype name "=" constvalue _listseparator?\ntypedef         :  "typedef" definitiontype type_annotations name type_annotations _listseparator?\nenum            :  "enum" name "{" enumfield* "}" type_annotations\nenumfield       :  name enumvalue type_annotations _listseparator?\nenumvalue       : ("=" INTCONSTANT)?\nsenum           :  "senum" name "{" senumfield* "}"\nsenumfield      :  LITERAL _listseparator?\nstruct          :  "struct" name "xsd_all"? "{" field* "}" type_annotations\nname            :  IDENTIFIER\nunion           :  "union" name "xsd_all"? "{" field* "}"\nexception       :  "exception" name "{" field* "}"\nservice         :  "service" name extends? "{" function* "}" type_annotations\nextends         :  "extends" IDENTIFIER\nfield           :  fieldid fieldreq fieldtype type_annotations IDENTIFIER fieldvalue xsdfieldoptions type_annotations _listseparator?\nfieldvalue      : ("=" constvalue)?\nfieldid         :  (INTCONSTANT ":")?\nfieldreq       :  ("required" | "optional")?\n?xsdfieldoptions:  "xsd_optional"? "xsd_nillable"? xsdattrs?\nxsdattrs        :  "xsd_attrs" "{" field* "}"\nfunction        :  oneway functiontype name "(" field* ")" throws type_annotations _listseparator?\noneway          :  ("oneway")?\n!functiontype   :  fieldtype | "void"\nthrows          :  ( "throws" "(" field* ")" )?\nfieldtype       :  IDENTIFIER | basetype | containertype\ndefinitiontype  :  IDENTIFIER | basetype | containertype\n!basetype       :  "bool" | "byte" | "i8" | "i16" | "i32" | "i64" | "double" | "string" | "binary" | "slist"\ncontainertype   :  maptype | settype | listtype\nmaptype         :  "map" cpptype? "<" fieldtype "," fieldtype ">"\nsettype         :  "set" cpptype? "<" fieldtype ">"\nlisttype        :  "list" "<" fieldtype ">" cpptype?\ncpptype         :  "cpp_type" LITERAL\n!constvalue     :  INTCONSTANT | DOUBLECONSTANT | LITERAL | IDENTIFIER | constlist | constmap\nINTCONSTANT     :  ("+" | "-")? DIGIT+\nDOUBLECONSTANT  :  ("+" | "-")? DIGIT* "." DIGIT+ ( ("E" | "e") INTCONSTANT )?\nconstlist       :  "[" constlistelt* "]"\nconstlistelt    :  constvalue _listseparator?\nconstmap        :  "{" constmapelt* "}"\nconstmapelt     :  constvalue ":" constvalue _listseparator?\n\ntype_annotations : ( "(" type_annotation* ")" )?\ntype_annotation : name "=" constvalue _listseparator?\n\nLITERAL         :  ("\\"" /[^"]/* "\\"") | ("\'" /[^\']/* "\'")\nIDENTIFIER      :  ( LETTER | "_" ) ( LETTER | DIGIT | "." | "_" )*\n_listseparator   :  "," | ";"\nLETTER          :  "A".."Z" | "a".."z"\nDIGIT           :  "0".."9"\nWHITESPACE      :  (" " | "\\t" | "\\r" | "\\n")+\n\n%import common.NEWLINE\nCOMMENT         :  "/*" /(.|\\n|\\r)*?/ "*/"\n                |  "//" /(.)*/ NEWLINE\n                |  "#"  /(.)*/ NEWLINE\n%ignore WHITESPACE\n%ignore COMMENT\n'
from lark import Lark

class Parser(Lark):

    def __init__(self):
        Lark.__init__(self, grammar, parser='earley', lexer='standard')

def parse(src):
    return parser.parse(src)
