
import sys
import codecs
import gzip
import re
import os.path
import random
import base64
import hashlib
VERSION = '5.30'
if (sys.hexversion >= 50331648):
    import tokenize
    open_in = tokenize.open
    unicode = str
    PY3 = True
    PY2 = False
    from io import BytesIO
    PY_VERSION = 3
else:
    unicode = unicode
    open_in = open
    PY2 = True
    PY3 = False
    from cStringIO import StringIO as BytesIO
    PY_VERSION = 2
PY_EXTENSIONS = ('.py', '.pyw')
STDLIB_PATH = os.path.dirname(os.__file__)

def get_analysis_version():
    return PYTHON_ANALYSIS_VERSION

def get_analysis_major_version():
    return PYTHON_ANALYSIS_MAJOR_VERSION

def update_analysis_version(version):
    global PYTHON_ANALYSIS_VERSION
    PYTHON_ANALYSIS_VERSION = version
    global PYTHON_ANALYSIS_MAJOR_VERSION
    PYTHON_ANALYSIS_MAJOR_VERSION = (2 if PYTHON_ANALYSIS_VERSION.startswith('2') else 3)
update_analysis_version(os.environ.get('CODEQL_EXTRACTOR_PYTHON_ANALYSIS_VERSION', '3'))
NORMAL_EDGE = 1
FALSE_EDGE = 2
TRUE_EDGE = 4
EXCEPTIONAL_EDGE = 8
EXHAUSTED_EDGE = 16

class SemmleError(Exception):
    pass

def printf(fmt, *args):
    sys.stdout.write((fmt % args))

def fprintf(fout, fmt, *args):
    fout.write((fmt % args))

def safe_string(txt):
    if (len(txt) > 10000):
        txt = (txt[:10000] + '...')
    return txt.replace('"', '""')

def escaped_string(txt):
    return txt.replace('"', '""')
if (os.name == 'nt'):
    MAGIC_PREFIX = '\\\\?\\'

    def safe_path(path):
        if path.startswith(MAGIC_PREFIX):
            return path
        return (MAGIC_PREFIX + os.path.abspath(path))
    _open = open

    def open(path, *args):
        assert (safe_path(path) == path)
        return _open(path, *args)
else:

    def safe_path(path):
        if os.path.isabs(path):
            return path
        return os.path.abspath(path)
AUTO_GEN_STRING = '/* AUTO GENERATED PART STARTS HERE */\n'

def folder_tag(name):
    return (name + ';folder')

def trap_id_escape(s):
    s = s.replace('&', '&amp;')
    s = s.replace('{', '&lbrace;')
    s = s.replace('}', '&rbrace;')
    s = s.replace('"', '&quot;')
    s = s.replace('@', '&commat;')
    s = s.replace('#', '&num;')
    return s

def generate_formatting_function(fmt):
    func_name = ('format_' + fmt)
    args = (['self', 'name'] + [('arg%d' % i) for i in range(len(fmt))])
    defn = ('def %s(%s):\n' % (func_name, ', '.join(args)))
    values = [_formatting_functions[f](a) for (f, a) in zip(fmt, args[2:])]
    format_string = (("u'%s(" + ', '.join((['%s'] * len(fmt)))) + ")\\n'")
    body = ('    self.out.write(%s %% (%s))\n' % (format_string, ',\n'.join((['name'] + values))))
    func = (defn + body)
    namespace = globals()
    exec(func, namespace)
    function = namespace[func_name]
    del namespace[func_name]
    return function

def _format_d(val):
    return ('repr(%s)' % val)

def _format_g(val):
    return ('self.pool.get(%s, %s)' % (val, val))

def _format_n(val):
    return ("self.pool.get(%s, %s.trap_name) if hasattr(%s, 'trap_name') else self.pool.get(%s)" % (val, val, val, val))

def _format_r(val):
    return val

def _format_u(val):
    return ('_INVALID_RE.sub(u\'�\', u\'"%%s"\' %% safe_string(%s))' % val)

def _format_b(val):
    return ('u\'"%%s"\' %% safe_string(%s.decode("latin-1"))' % val)

def _format_s(val):
    return ('%s if isinstance(%s, bytes) else _INVALID_RE.sub(u\'�\', u\'"%%s"\' %% safe_string(unicode(%s)))' % (_format_b(val), val, val))

def _format_B(val):
    return ('u\'"%%s"\' %% escaped_string(%s.decode("latin-1"))' % val)

def _format_S(val):
    return ('%s if isinstance(%s, bytes) else _INVALID_RE.sub(u\'�\', u\'"%%s"\' %% escaped_string(unicode(%s)))' % (_format_B(val), val, val))

def _format_x(val):
    return ('(u"false", u"true")[%s]' % val)

def _format_q(val):
    return ('format_numeric_literal(%s)' % val)
_formatting_functions = {'b': _format_b, 'd': _format_d, 'g': _format_g, 'n': _format_n, 'r': _format_r, 's': _format_s, 'u': _format_u, 'x': _format_x, 'q': _format_q, 'B': _format_B, 'S': _format_S}
if PY2:

    def format_numeric_literal(val):
        txt = repr(val)
        if (txt[(- 1)] == 'L'):
            txt = txt[:(- 1)]
        return ('"%s"' % txt.decode('ascii'))
else:

    def format_numeric_literal(val):
        txt = repr(val)
        return ('"%s"' % txt)

class Buffer(object):

    def __init__(self, out):
        self.out = out
        self.buf = []

    def write(self, content):
        self.buf.append(content)
        if (len(self.buf) > 10000):
            self.flush()

    def close(self):
        self.flush()
        self.out.close()

    def flush(self):
        self.out.write(''.join(self.buf))
        self.buf = []

class Utf8Zip(object):

    def __init__(self):
        self.raw = BytesIO()
        gout = gzip.GzipFile('', 'wb', 5, fileobj=self.raw)
        self.out = codecs.getwriter('utf-8')(gout, errors='backslashreplace')

    def write(self, data):
        self.out.write(data)

    def close(self):
        self.out.close()

    def getvalue(self):
        return self.raw.getvalue()

class TrapWriter(object):
    _format_functions = {}

    def __init__(self):
        self.zip = Utf8Zip()
        self.out = Buffer(self.zip)
        self.pool = IDPool(self.out)
        self.written_containers = {}

    def write_tuple(self, name, fmt, *args):
        if (fmt in self._format_functions):
            return self._format_functions[fmt](self, name, *args)
        func = generate_formatting_function(fmt)
        self._format_functions[fmt] = func
        return func(self, name, *args)

    def get_node_id(self, node):
        if hasattr(node, 'trap_name'):
            return self.pool.get(node, node.trap_name)
        else:
            return self.pool.get(node)

    def has_written(self, node):
        return (node in self.pool.pool)

    def get_unique_id(self):
        return self.pool.get_unique_id()
    'Return an id that is shared across trap files,\n       whenever the label is used'

    def get_labelled_id(self, obj, label):
        return self.pool.get(obj, label)

    def write_container(self, fullpath, is_file):
        if (fullpath in self.written_containers):
            return self.written_containers[fullpath]
        (folder, filename) = os.path.split(fullpath)
        if is_file:
            tag = get_source_file_tag(fullpath)
            self.write_tuple('files', 'gs', tag, fullpath)
        else:
            tag = get_folder_tag(fullpath)
            self.write_tuple('folders', 'gs', tag, fullpath)
        self.written_containers[fullpath] = tag
        if (folder and filename):
            folder_tag = self.write_container(folder, False)
            self.write_tuple('containerparent', 'gg', folder_tag, tag)
        return tag

    def write_file(self, fullpath):
        return self.write_container(fullpath, True)

    def write_folder(self, fullpath):
        return self.write_container(fullpath, False)

    def get_compressed(self):
        self.out.close()
        return self.zip.getvalue()

    def write_comment(self, text):
        self.out.write(('// %s\n' % text))
_INVALID_RE = re.compile('[^\x00-\ud7ff\ue000-\uffff]', re.UNICODE)

class _HashableList(object):

    def __init__(self, items):
        self.items = items

    def __eq__(self, other):
        if (not isinstance(other, _HashableList)):
            return False
        return (self.items is other.items)

    def __ne__(self, other):
        if (not isinstance(other, _HashableList)):
            return True
        return (self.items is not other.items)

    def __hash__(self):
        return id(self.items)

class IDPool(object):

    def __init__(self, out, init_id=10000):
        self.out = out
        self.pool = {}
        self.next_id = init_id

    def get_unique_id(self):
        res = ('#' + unicode(self.next_id))
        self.out.write((res + ' = *\n'))
        self.next_id += 1
        return res

    def get(self, node, name=None):
        if (type(node) is list):
            node = _HashableList(node)
        if (node in self.pool):
            return self.pool[node]
        next_id = ('#' + unicode(self.next_id))
        if (name is not None):
            name = unicode(name)
            name = ('@"%s"' % safe_string(trap_id_escape(name)))
        else:
            name = '*'
        self.out.write(('%s = %s\n' % (next_id, name)))
        self.pool[node] = next_id
        self.next_id += 1
        return next_id

def get_folder_tag(folder):
    return str_to_unicode(('/'.join(folder.split(os.path.sep)) + ';folder'))

def get_source_file_tag(fullpath):
    return (str_to_unicode(fullpath, sys.getfilesystemencoding()) + ';sourcefile')

def makedirs(path):
    try:
        os.makedirs(path)
    except OSError:
        if (not os.path.isdir(path)):
            raise

def clean_cache(subdir, suffix, verbose):
    if os.path.exists(subdir):
        for filename in os.listdir(subdir):
            if (not filename.endswith(suffix)):
                continue
            filepath = os.path.join(subdir, filename)
            try:
                if verbose:
                    print(('Deleting stale trap file: ' + filepath))
                os.remove(filepath)
            except Exception as ex:
                if verbose:
                    msg = 'Failed to remove stale trap file %s due to %s'
                    print((msg % (filepath, repr(ex))))
    else:
        makedirs(subdir)
if (os.name == 'nt'):

    def storage_path(container, path):
        path = path.replace(':', '_')
        if os.path.isabs(path):
            path = path[1:]
        return safe_path(os.path.join(container, path))

    def isdir(path):
        if (len(path) > 240):
            path = ('\\\\?\\' + path)
        return os.path.isdir(path)

    def islink(path):
        if (len(path) > 240):
            path = ('\\\\?\\' + path)
        return os.path.islink(path)

    def listdir(path):
        if (len(path) > 240):
            path = ('\\\\?\\' + path)
        return os.listdir(path)
else:

    def storage_path(container, path):
        if os.path.isabs(path):
            path = path[1:]
        return safe_path(os.path.join(container, path))
    isdir = os.path.isdir
    islink = os.path.islink
    listdir = os.listdir
if PY2:

    def str_to_unicode(txt, encoding=None):
        if isinstance(txt, unicode):
            return txt
        if (encoding is None):
            encoding = 'utf8'
        try:
            return txt.decode(encoding)
        except UnicodeDecodeError:
            return txt.decode('latin-1')

    def unicode_to_str(txt, encoding=None):
        if isinstance(txt, str):
            return txt
        if (encoding is None):
            encoding = 'utf8'
        return txt.encode(encoding, errors='escape')
else:

    def str_to_unicode(txt, encoding='utf8'):
        return txt

    def unicode_to_str(txt, encoding='utf8'):
        return txt
LATIN1 = codecs.lookup('latin-1')
UTF8 = codecs.lookup('utf-8')

def was_interned_ascii_bytes(txt):
    return (txt is intern(txt[:]))

def is_a_number(txt):
    try:
        float(txt)
        return True
    except ValueError:
        return False
USE_INTOLERANT_ENCODING = False

def change_default_encoding():
    if USE_INTOLERANT_ENCODING:

        def _decode(input, errors=None):
            if ((not was_interned_ascii_bytes(input)) and (not is_a_number(input))):
                f = sys._getframe(1)
                if ('semmle' in f.f_code.co_filename):
                    raise SemmleError((b"Implicit decode of '%s' at %s:%d" % (input, f.f_code.co_filename, f.f_lineno)))
            try:
                return UTF8.decode(input)
            except UnicodeDecodeError:
                return LATIN1.decode(input)

        def _encode(input, errors=None):
            f = sys._getframe(1)
            if ('semmle' in f.f_code.co_filename):
                raise SemmleError(("Implicit encode of '%s' at %s:%d" % (UTF8.encode(input), f.f_code.co_filename, f.f_lineno)))
            return UTF8.encode(input, 'backslashreplace')
    else:

        def _decode(input, errors=None):
            try:
                return UTF8.decode(input)
            except UnicodeDecodeError:
                return LATIN1.decode(input)

        def _encode(input, errors=None):
            return UTF8.encode(input, 'backslashreplace')

    def search(name):
        if (name != 'safe'):
            return None
        return codecs.CodecInfo(_encode, _decode, name='safe')
    codecs.register(search)
    reload(sys)
    sys.setdefaultencoding('safe')
    del sys.setdefaultencoding
_sys_rand = random.SystemRandom()

def uuid(local_name):
    hex_string = hex(_sys_rand.randrange((1 << 256)))
    if PY2:
        return ((hex_string[2:(- 1)] + '-') + local_name)
    else:
        return ((hex_string[2:] + '-') + local_name)

class Extractable(object):

    def __ne__(self, other):
        return (not (self == other))

    @staticmethod
    def from_path(path):
        if os.path.isdir(path):
            return FolderExtractable(path)
        elif os.path.isfile(path):
            return FileExtractable(path)
        else:
            raise IOError(('% does not exist' % path))

class PathExtractable(Extractable):
    PATTERN = 421706893
    __slots__ = ['path']

    def __init__(self, path):
        assert ('<compiled code>' not in path)
        self.path = path

    def __eq__(self, other):
        return (isinstance(other, type(self)) and (self.path == other.path))

    def __hash__(self):
        return (hash(self.path) ^ self.PATTERN)

class FileExtractable(PathExtractable):
    PATTERN = 1903946595
    __slots__ = ['path']

    def __str__(self):
        return ('file ' + self.path)

    def __repr__(self):
        return ('FileExtractable(%r)' % self.path)

class FolderExtractable(PathExtractable):
    PATTERN = 712343093
    __slots__ = ['path']

    def __str__(self):
        return ('folder ' + self.path)

    def __repr__(self):
        return ('FolderExtractable(%r)' % self.path)

class BuiltinModuleExtractable(Extractable):
    __slots__ = ['name']

    def __init__(self, name):
        self.name = name

    def __str__(self):
        return ('module ' + self.name)

    def __repr__(self):
        return ('BuiltinModuleExtractable(%r)' % self.name)

    def __eq__(self, other):
        return (isinstance(other, BuiltinModuleExtractable) and (self.name == other.name))

    def __hash__(self):
        return (hash(self.name) ^ 82753421)

def base64digest(code):
    return base64.b64encode(hashlib.sha1(code.encode('utf8')).digest(), b'_-').decode('ascii')
