package com.semmle.util.language;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_ExtractorOptionsSpec extends ExtractorOptionsSpec {

  private final String title;

  private final String description;

  private final ExtractorOptionsSpec.OptionType type;

  private final Optional<String> patternString;

  private final Optional<Integer> visibility;

  private final Map<String, ExtractorOptionsSpec> properties;

  $AutoValue_ExtractorOptionsSpec(
      String title,
      String description,
      ExtractorOptionsSpec.OptionType type,
      Optional<String> patternString,
      Optional<Integer> visibility,
      Map<String, ExtractorOptionsSpec> properties) {
    if (title == null) {
      throw new NullPointerException("Null title");
    }
    this.title = title;
    if (description == null) {
      throw new NullPointerException("Null description");
    }
    this.description = description;
    if (type == null) {
      throw new NullPointerException("Null type");
    }
    this.type = type;
    if (patternString == null) {
      throw new NullPointerException("Null patternString");
    }
    this.patternString = patternString;
    if (visibility == null) {
      throw new NullPointerException("Null visibility");
    }
    this.visibility = visibility;
    if (properties == null) {
      throw new NullPointerException("Null properties");
    }
    this.properties = properties;
  }

  @Override
  public String getTitle() {
    return title;
  }

  @Override
  public String getDescription() {
    return description;
  }

  @Override
  public ExtractorOptionsSpec.OptionType getType() {
    return type;
  }

  @Override
  public Optional<String> getPatternString() {
    return patternString;
  }

  @Override
  public Optional<Integer> getVisibility() {
    return visibility;
  }

  @Override
  public Map<String, ExtractorOptionsSpec> getProperties() {
    return properties;
  }

  @Override
  public String toString() {
    return "ExtractorOptionsSpec{"
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "type=" + type + ", "
        + "patternString=" + patternString + ", "
        + "visibility=" + visibility + ", "
        + "properties=" + properties
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ExtractorOptionsSpec) {
      ExtractorOptionsSpec that = (ExtractorOptionsSpec) o;
      return this.title.equals(that.getTitle())
          && this.description.equals(that.getDescription())
          && this.type.equals(that.getType())
          && this.patternString.equals(that.getPatternString())
          && this.visibility.equals(that.getVisibility())
          && this.properties.equals(that.getProperties());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= patternString.hashCode();
    h$ *= 1000003;
    h$ ^= visibility.hashCode();
    h$ *= 1000003;
    h$ ^= properties.hashCode();
    return h$;
  }

  static class Builder extends ExtractorOptionsSpec.Builder {
    private String title;
    private String description;
    private ExtractorOptionsSpec.OptionType type;
    private Optional<String> patternString = Optional.empty();
    private Optional<Integer> visibility = Optional.empty();
    private Map<String, ExtractorOptionsSpec> properties;
    Builder() {
    }
    @Override
    public ExtractorOptionsSpec.Builder setTitle(String title) {
      if (title == null) {
        throw new NullPointerException("Null title");
      }
      this.title = title;
      return this;
    }
    @Override
    Optional<String> getTitle() {
      if (title == null) {
        return Optional.empty();
      } else {
        return Optional.of(title);
      }
    }
    @Override
    public ExtractorOptionsSpec.Builder setDescription(String description) {
      if (description == null) {
        throw new NullPointerException("Null description");
      }
      this.description = description;
      return this;
    }
    @Override
    Optional<String> getDescription() {
      if (description == null) {
        return Optional.empty();
      } else {
        return Optional.of(description);
      }
    }
    @Override
    public ExtractorOptionsSpec.Builder setType(ExtractorOptionsSpec.OptionType type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    Optional<ExtractorOptionsSpec.OptionType> getType() {
      if (type == null) {
        return Optional.empty();
      } else {
        return Optional.of(type);
      }
    }
    @Override
    public ExtractorOptionsSpec.Builder setPatternString(String patternString) {
      this.patternString = Optional.of(patternString);
      return this;
    }
    @Override
    Optional<String> getPatternString() {
      return patternString;
    }
    @Override
    public ExtractorOptionsSpec.Builder setVisibility(Integer visibility) {
      this.visibility = Optional.of(visibility);
      return this;
    }
    @Override
    Optional<Integer> getVisibility() {
      return visibility;
    }
    @Override
    public ExtractorOptionsSpec.Builder setProperties(Map<String, ExtractorOptionsSpec> properties) {
      if (properties == null) {
        throw new NullPointerException("Null properties");
      }
      this.properties = properties;
      return this;
    }
    @Override
    Optional<Map<String, ExtractorOptionsSpec>> getProperties() {
      if (properties == null) {
        return Optional.empty();
      } else {
        return Optional.of(properties);
      }
    }
    @Override
    ExtractorOptionsSpec autoBuild() {
      String missing = "";
      if (this.title == null) {
        missing += " title";
      }
      if (this.description == null) {
        missing += " description";
      }
      if (this.type == null) {
        missing += " type";
      }
      if (this.properties == null) {
        missing += " properties";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ExtractorOptionsSpec(
          this.title,
          this.description,
          this.type,
          this.patternString,
          this.visibility,
          this.properties);
    }
  }

}
