package com.semmle.util.language;

import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_FileTypeSpec extends FileTypeSpec {

  private final String id;

  private final String name;

  private final List<String> extensions;

  private AutoValue_FileTypeSpec(
      String id,
      String name,
      List<String> extensions) {
    this.id = id;
    this.name = name;
    this.extensions = extensions;
  }

  @Override
  public String getId() {
    return id;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public List<String> getExtensions() {
    return extensions;
  }

  @Override
  public String toString() {
    return "FileTypeSpec{"
        + "id=" + id + ", "
        + "name=" + name + ", "
        + "extensions=" + extensions
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof FileTypeSpec) {
      FileTypeSpec that = (FileTypeSpec) o;
      return this.id.equals(that.getId())
          && this.name.equals(that.getName())
          && this.extensions.equals(that.getExtensions());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= extensions.hashCode();
    return h$;
  }

  static final class Builder extends FileTypeSpec.Builder {
    private String id;
    private String name;
    private List<String> extensions;
    Builder() {
    }
    @Override
    public FileTypeSpec.Builder setId(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    Optional<String> getId() {
      if (id == null) {
        return Optional.empty();
      } else {
        return Optional.of(id);
      }
    }
    @Override
    public FileTypeSpec.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    Optional<String> getName() {
      if (name == null) {
        return Optional.empty();
      } else {
        return Optional.of(name);
      }
    }
    @Override
    public FileTypeSpec.Builder setExtensions(List<String> extensions) {
      if (extensions == null) {
        throw new NullPointerException("Null extensions");
      }
      this.extensions = extensions;
      return this;
    }
    @Override
    Optional<List<String>> getExtensions() {
      if (extensions == null) {
        return Optional.empty();
      } else {
        return Optional.of(extensions);
      }
    }
    @Override
    FileTypeSpec autoBuild() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.extensions == null) {
        missing += " extensions";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_FileTypeSpec(
          this.id,
          this.name,
          this.extensions);
    }
  }

}
