package com.semmle.cli2.resolve.result;

import java.util.Map;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ExtractorOptionsInfo extends ExtractorOptionsInfo {

  private final String title;

  private final String description;

  private final String type;

  private final String pattern;

  private final Integer visibility;

  private final Map<String, ExtractorOptionsInfo> properties;

  private AutoValue_ExtractorOptionsInfo(
      String title,
      String description,
      String type,
      @ExtractorOptionsInfo.Nullable String pattern,
      @ExtractorOptionsInfo.Nullable Integer visibility,
      @ExtractorOptionsInfo.Nullable Map<String, ExtractorOptionsInfo> properties) {
    this.title = title;
    this.description = description;
    this.type = type;
    this.pattern = pattern;
    this.visibility = visibility;
    this.properties = properties;
  }

  @Override
  public String getTitle() {
    return title;
  }

  @Override
  public String getDescription() {
    return description;
  }

  @Override
  public String getType() {
    return type;
  }

  @ExtractorOptionsInfo.Nullable
  @Override
  public String getPattern() {
    return pattern;
  }

  @ExtractorOptionsInfo.Nullable
  @Override
  public Integer getVisibility() {
    return visibility;
  }

  @ExtractorOptionsInfo.Nullable
  @Override
  public Map<String, ExtractorOptionsInfo> getProperties() {
    return properties;
  }

  @Override
  public String toString() {
    return "ExtractorOptionsInfo{"
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "type=" + type + ", "
        + "pattern=" + pattern + ", "
        + "visibility=" + visibility + ", "
        + "properties=" + properties
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ExtractorOptionsInfo) {
      ExtractorOptionsInfo that = (ExtractorOptionsInfo) o;
      return this.title.equals(that.getTitle())
          && this.description.equals(that.getDescription())
          && this.type.equals(that.getType())
          && (this.pattern == null ? that.getPattern() == null : this.pattern.equals(that.getPattern()))
          && (this.visibility == null ? that.getVisibility() == null : this.visibility.equals(that.getVisibility()))
          && (this.properties == null ? that.getProperties() == null : this.properties.equals(that.getProperties()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (pattern == null) ? 0 : pattern.hashCode();
    h$ *= 1000003;
    h$ ^= (visibility == null) ? 0 : visibility.hashCode();
    h$ *= 1000003;
    h$ ^= (properties == null) ? 0 : properties.hashCode();
    return h$;
  }

  static final class Builder extends ExtractorOptionsInfo.Builder {
    private String title;
    private String description;
    private String type;
    private String pattern;
    private Integer visibility;
    private Map<String, ExtractorOptionsInfo> properties;
    Builder() {
    }
    @Override
    public ExtractorOptionsInfo.Builder setTitle(String title) {
      if (title == null) {
        throw new NullPointerException("Null title");
      }
      this.title = title;
      return this;
    }
    @Override
    public ExtractorOptionsInfo.Builder setDescription(String description) {
      if (description == null) {
        throw new NullPointerException("Null description");
      }
      this.description = description;
      return this;
    }
    @Override
    public ExtractorOptionsInfo.Builder setType(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public ExtractorOptionsInfo.Builder setPattern(String pattern) {
      this.pattern = pattern;
      return this;
    }
    @Override
    public ExtractorOptionsInfo.Builder setVisibility(Integer visibility) {
      this.visibility = visibility;
      return this;
    }
    @Override
    public ExtractorOptionsInfo.Builder setProperties(Map<String, ExtractorOptionsInfo> properties) {
      this.properties = properties;
      return this;
    }
    @Override
    public ExtractorOptionsInfo build() {
      String missing = "";
      if (this.title == null) {
        missing += " title";
      }
      if (this.description == null) {
        missing += " description";
      }
      if (this.type == null) {
        missing += " type";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ExtractorOptionsInfo(
          this.title,
          this.description,
          this.type,
          this.pattern,
          this.visibility,
          this.properties);
    }
  }

}
