package com.semmle.cli2.resolve.result;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ResolveExtractorResult extends ResolveExtractorResult {

  private final Path extractorRoot;

  private final Map<String, ExtractorOptionsInfo> extractorOptions;

  private AutoValue_ResolveExtractorResult(
      Path extractorRoot,
      @ResolveExtractorResult.Nullable Map<String, ExtractorOptionsInfo> extractorOptions) {
    this.extractorRoot = extractorRoot;
    this.extractorOptions = extractorOptions;
  }

  @Override
  public Path getExtractorRoot() {
    return extractorRoot;
  }

  @ResolveExtractorResult.Nullable
  @Override
  public Map<String, ExtractorOptionsInfo> getExtractorOptions() {
    return extractorOptions;
  }

  @Override
  public String toString() {
    return "ResolveExtractorResult{"
        + "extractorRoot=" + extractorRoot + ", "
        + "extractorOptions=" + extractorOptions
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ResolveExtractorResult) {
      ResolveExtractorResult that = (ResolveExtractorResult) o;
      return this.extractorRoot.equals(that.getExtractorRoot())
          && (this.extractorOptions == null ? that.getExtractorOptions() == null : this.extractorOptions.equals(that.getExtractorOptions()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= extractorRoot.hashCode();
    h$ *= 1000003;
    h$ ^= (extractorOptions == null) ? 0 : extractorOptions.hashCode();
    return h$;
  }

  static final class Builder extends ResolveExtractorResult.Builder {
    private Path extractorRoot;
    private Map<String, ExtractorOptionsInfo> extractorOptions;
    Builder() {
    }
    @Override
    public ResolveExtractorResult.Builder setExtractorRoot(Path extractorRoot) {
      if (extractorRoot == null) {
        throw new NullPointerException("Null extractorRoot");
      }
      this.extractorRoot = extractorRoot;
      return this;
    }
    @Override
    public ResolveExtractorResult.Builder setExtractorOptions(Map<String, ExtractorOptionsInfo> extractorOptions) {
      this.extractorOptions = extractorOptions;
      return this;
    }
    @Override
    @ResolveExtractorResult.Nullable Optional<Map<String, ExtractorOptionsInfo>> getExtractorOptions() {
      if (extractorOptions == null) {
        return Optional.empty();
      } else {
        return Optional.of(extractorOptions);
      }
    }
    @Override
    public ResolveExtractorResult build() {
      String missing = "";
      if (this.extractorRoot == null) {
        missing += " extractorRoot";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ResolveExtractorResult(
          this.extractorRoot,
          this.extractorOptions);
    }
  }

}
