package com.semmle.util.language;

import com.semmle.util.version.SemanticVersion;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_LanguagePackSpec extends LanguagePackSpec {

  private final String name;

  private final String displayName;

  private final SemanticVersion version;

  private final List<String> pullRequestTriggers;

  private final ColumnKind columnKind;

  private final boolean unicodeNewlines;

  private final Map<String, String> extraEnvVars;

  private final List<FileTypeSpec> fileTypes;

  private final boolean legacyQltestExtraction;

  private final Map<String, ExtractorOptionsSpec> options;

  private final Collection<String> githubApiLanguages;

  private final Collection<String> sccLanguages;

  $AutoValue_LanguagePackSpec(
      String name,
      String displayName,
      SemanticVersion version,
      List<String> pullRequestTriggers,
      ColumnKind columnKind,
      boolean unicodeNewlines,
      Map<String, String> extraEnvVars,
      List<FileTypeSpec> fileTypes,
      boolean legacyQltestExtraction,
      Map<String, ExtractorOptionsSpec> options,
      Collection<String> githubApiLanguages,
      Collection<String> sccLanguages) {
    if (name == null) {
      throw new NullPointerException("Null name");
    }
    this.name = name;
    if (displayName == null) {
      throw new NullPointerException("Null displayName");
    }
    this.displayName = displayName;
    if (version == null) {
      throw new NullPointerException("Null version");
    }
    this.version = version;
    if (pullRequestTriggers == null) {
      throw new NullPointerException("Null pullRequestTriggers");
    }
    this.pullRequestTriggers = pullRequestTriggers;
    if (columnKind == null) {
      throw new NullPointerException("Null columnKind");
    }
    this.columnKind = columnKind;
    this.unicodeNewlines = unicodeNewlines;
    if (extraEnvVars == null) {
      throw new NullPointerException("Null extraEnvVars");
    }
    this.extraEnvVars = extraEnvVars;
    if (fileTypes == null) {
      throw new NullPointerException("Null fileTypes");
    }
    this.fileTypes = fileTypes;
    this.legacyQltestExtraction = legacyQltestExtraction;
    if (options == null) {
      throw new NullPointerException("Null options");
    }
    this.options = options;
    if (githubApiLanguages == null) {
      throw new NullPointerException("Null githubApiLanguages");
    }
    this.githubApiLanguages = githubApiLanguages;
    if (sccLanguages == null) {
      throw new NullPointerException("Null sccLanguages");
    }
    this.sccLanguages = sccLanguages;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public String getDisplayName() {
    return displayName;
  }

  @Override
  public SemanticVersion getVersion() {
    return version;
  }

  @Override
  public List<String> getPullRequestTriggers() {
    return pullRequestTriggers;
  }

  @Override
  public ColumnKind getColumnKind() {
    return columnKind;
  }

  @Override
  public boolean getUnicodeNewlines() {
    return unicodeNewlines;
  }

  @Override
  public Map<String, String> getExtraEnvVars() {
    return extraEnvVars;
  }

  @Override
  public List<FileTypeSpec> getFileTypes() {
    return fileTypes;
  }

  @Override
  public boolean getLegacyQltestExtraction() {
    return legacyQltestExtraction;
  }

  @Override
  public Map<String, ExtractorOptionsSpec> getOptions() {
    return options;
  }

  @Override
  public Collection<String> getGithubApiLanguages() {
    return githubApiLanguages;
  }

  @Override
  public Collection<String> getSccLanguages() {
    return sccLanguages;
  }

  @Override
  public String toString() {
    return "LanguagePackSpec{"
        + "name=" + name + ", "
        + "displayName=" + displayName + ", "
        + "version=" + version + ", "
        + "pullRequestTriggers=" + pullRequestTriggers + ", "
        + "columnKind=" + columnKind + ", "
        + "unicodeNewlines=" + unicodeNewlines + ", "
        + "extraEnvVars=" + extraEnvVars + ", "
        + "fileTypes=" + fileTypes + ", "
        + "legacyQltestExtraction=" + legacyQltestExtraction + ", "
        + "options=" + options + ", "
        + "githubApiLanguages=" + githubApiLanguages + ", "
        + "sccLanguages=" + sccLanguages
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof LanguagePackSpec) {
      LanguagePackSpec that = (LanguagePackSpec) o;
      return this.name.equals(that.getName())
          && this.displayName.equals(that.getDisplayName())
          && this.version.equals(that.getVersion())
          && this.pullRequestTriggers.equals(that.getPullRequestTriggers())
          && this.columnKind.equals(that.getColumnKind())
          && this.unicodeNewlines == that.getUnicodeNewlines()
          && this.extraEnvVars.equals(that.getExtraEnvVars())
          && this.fileTypes.equals(that.getFileTypes())
          && this.legacyQltestExtraction == that.getLegacyQltestExtraction()
          && this.options.equals(that.getOptions())
          && this.githubApiLanguages.equals(that.getGithubApiLanguages())
          && this.sccLanguages.equals(that.getSccLanguages());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= displayName.hashCode();
    h$ *= 1000003;
    h$ ^= version.hashCode();
    h$ *= 1000003;
    h$ ^= pullRequestTriggers.hashCode();
    h$ *= 1000003;
    h$ ^= columnKind.hashCode();
    h$ *= 1000003;
    h$ ^= unicodeNewlines ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= extraEnvVars.hashCode();
    h$ *= 1000003;
    h$ ^= fileTypes.hashCode();
    h$ *= 1000003;
    h$ ^= legacyQltestExtraction ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= options.hashCode();
    h$ *= 1000003;
    h$ ^= githubApiLanguages.hashCode();
    h$ *= 1000003;
    h$ ^= sccLanguages.hashCode();
    return h$;
  }

  static class Builder extends LanguagePackSpec.Builder {
    private String name;
    private String displayName;
    private SemanticVersion version;
    private List<String> pullRequestTriggers;
    private ColumnKind columnKind;
    private Boolean unicodeNewlines;
    private Map<String, String> extraEnvVars;
    private List<FileTypeSpec> fileTypes;
    private Boolean legacyQltestExtraction;
    private Map<String, ExtractorOptionsSpec> options;
    private Collection<String> githubApiLanguages;
    private Collection<String> sccLanguages;
    Builder() {
    }
    @Override
    public LanguagePackSpec.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    Optional<String> getName() {
      if (name == null) {
        return Optional.empty();
      } else {
        return Optional.of(name);
      }
    }
    @Override
    public LanguagePackSpec.Builder setDisplayName(String displayName) {
      if (displayName == null) {
        throw new NullPointerException("Null displayName");
      }
      this.displayName = displayName;
      return this;
    }
    @Override
    Optional<String> getDisplayName() {
      if (displayName == null) {
        return Optional.empty();
      } else {
        return Optional.of(displayName);
      }
    }
    @Override
    public LanguagePackSpec.Builder setVersion(SemanticVersion version) {
      if (version == null) {
        throw new NullPointerException("Null version");
      }
      this.version = version;
      return this;
    }
    @Override
    Optional<SemanticVersion> getVersion() {
      if (version == null) {
        return Optional.empty();
      } else {
        return Optional.of(version);
      }
    }
    @Override
    public LanguagePackSpec.Builder setPullRequestTriggers(List<String> pullRequestTriggers) {
      if (pullRequestTriggers == null) {
        throw new NullPointerException("Null pullRequestTriggers");
      }
      this.pullRequestTriggers = pullRequestTriggers;
      return this;
    }
    @Override
    Optional<List<String>> getPullRequestTriggers() {
      if (pullRequestTriggers == null) {
        return Optional.empty();
      } else {
        return Optional.of(pullRequestTriggers);
      }
    }
    @Override
    public LanguagePackSpec.Builder setColumnKind(ColumnKind columnKind) {
      if (columnKind == null) {
        throw new NullPointerException("Null columnKind");
      }
      this.columnKind = columnKind;
      return this;
    }
    @Override
    Optional<ColumnKind> getColumnKind() {
      if (columnKind == null) {
        return Optional.empty();
      } else {
        return Optional.of(columnKind);
      }
    }
    @Override
    public LanguagePackSpec.Builder setUnicodeNewlines(boolean unicodeNewlines) {
      this.unicodeNewlines = unicodeNewlines;
      return this;
    }
    @Override
    Optional<Boolean> getUnicodeNewlines() {
      if (unicodeNewlines == null) {
        return Optional.empty();
      } else {
        return Optional.of(unicodeNewlines);
      }
    }
    @Override
    public LanguagePackSpec.Builder setExtraEnvVars(Map<String, String> extraEnvVars) {
      if (extraEnvVars == null) {
        throw new NullPointerException("Null extraEnvVars");
      }
      this.extraEnvVars = extraEnvVars;
      return this;
    }
    @Override
    Optional<Map<String, String>> getExtraEnvVars() {
      if (extraEnvVars == null) {
        return Optional.empty();
      } else {
        return Optional.of(extraEnvVars);
      }
    }
    @Override
    public LanguagePackSpec.Builder setFileTypes(List<FileTypeSpec> fileTypes) {
      if (fileTypes == null) {
        throw new NullPointerException("Null fileTypes");
      }
      this.fileTypes = fileTypes;
      return this;
    }
    @Override
    Optional<List<FileTypeSpec>> getFileTypes() {
      if (fileTypes == null) {
        return Optional.empty();
      } else {
        return Optional.of(fileTypes);
      }
    }
    @Override
    public LanguagePackSpec.Builder setLegacyQltestExtraction(boolean legacyQltestExtraction) {
      this.legacyQltestExtraction = legacyQltestExtraction;
      return this;
    }
    @Override
    Optional<Boolean> getLegacyQltestExtraction() {
      if (legacyQltestExtraction == null) {
        return Optional.empty();
      } else {
        return Optional.of(legacyQltestExtraction);
      }
    }
    @Override
    public LanguagePackSpec.Builder setOptions(Map<String, ExtractorOptionsSpec> options) {
      if (options == null) {
        throw new NullPointerException("Null options");
      }
      this.options = options;
      return this;
    }
    @Override
    Optional<Map<String, ExtractorOptionsSpec>> getOptions() {
      if (options == null) {
        return Optional.empty();
      } else {
        return Optional.of(options);
      }
    }
    @Override
    public LanguagePackSpec.Builder setGithubApiLanguages(Collection<String> githubApiLanguages) {
      if (githubApiLanguages == null) {
        throw new NullPointerException("Null githubApiLanguages");
      }
      this.githubApiLanguages = githubApiLanguages;
      return this;
    }
    @Override
    Optional<Collection<String>> getGithubApiLanguages() {
      if (githubApiLanguages == null) {
        return Optional.empty();
      } else {
        return Optional.of(githubApiLanguages);
      }
    }
    @Override
    public LanguagePackSpec.Builder setSccLanguages(Collection<String> sccLanguages) {
      if (sccLanguages == null) {
        throw new NullPointerException("Null sccLanguages");
      }
      this.sccLanguages = sccLanguages;
      return this;
    }
    @Override
    Optional<Collection<String>> getSccLanguages() {
      if (sccLanguages == null) {
        return Optional.empty();
      } else {
        return Optional.of(sccLanguages);
      }
    }
    @Override
    LanguagePackSpec autoBuild() {
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.displayName == null) {
        missing += " displayName";
      }
      if (this.version == null) {
        missing += " version";
      }
      if (this.pullRequestTriggers == null) {
        missing += " pullRequestTriggers";
      }
      if (this.columnKind == null) {
        missing += " columnKind";
      }
      if (this.unicodeNewlines == null) {
        missing += " unicodeNewlines";
      }
      if (this.extraEnvVars == null) {
        missing += " extraEnvVars";
      }
      if (this.fileTypes == null) {
        missing += " fileTypes";
      }
      if (this.legacyQltestExtraction == null) {
        missing += " legacyQltestExtraction";
      }
      if (this.options == null) {
        missing += " options";
      }
      if (this.githubApiLanguages == null) {
        missing += " githubApiLanguages";
      }
      if (this.sccLanguages == null) {
        missing += " sccLanguages";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_LanguagePackSpec(
          this.name,
          this.displayName,
          this.version,
          this.pullRequestTriggers,
          this.columnKind,
          this.unicodeNewlines,
          this.extraEnvVars,
          this.fileTypes,
          this.legacyQltestExtraction,
          this.options,
          this.githubApiLanguages,
          this.sccLanguages);
    }
  }

}
