import os
import shutil

def copy_folder(src, dst):
    """
    复制文件夹，忽略以字母t开头的子文件夹
    :param src: 源文件夹路径
    :param dst: 目标文件夹路径
    """
    # 确保目标文件夹存在
    if not os.path.exists(dst):
        os.makedirs(dst)

    # 遍历源文件夹
    for item in os.listdir(src):
        src_item = os.path.join(src, item)
        dst_item = os.path.join(dst, item)

        # 如果是文件，直接复制
        if os.path.isfile(src_item):
            shutil.copy2(src_item, dst_item)
        # 如果是文件夹
        elif os.path.isdir(src_item):
            # 如果文件夹名以t开头，跳过
            if item.lower().startswith('model'):
                print(f"Skipping folder: {item}")
                continue
            # 否则递归复制文件夹
            copy_folder(src_item, dst_item)

# 示例用法
source_folder = "/mnt/lyc/wuxinrui/Qwen2.5-Math/evaluation"  # 源文件夹路径
destination_folder = "/mnt/lyc/wuxinrui/BudgetThinker/evaluation"  # 目标文件夹路径

copy_folder(source_folder, destination_folder)
print("Folder copied successfully.")