import matplotlib.pyplot as plt

# 数据
data = {
    'TokenMeter 6k': [(0.47, 79.6), (0.678, 85.2), (0.762, 86), (0.856, 84.6)],
    'TokenMeter 6k-4k': [(0.628, 80), (0.786, 86), (0.858, 84.6), (0.938, 86.4)],
    'TokenMeter 6k-4k-3k': [(0.664, 80), (0.846, 84.2), (0.898, 85), (0.954, 87.2)],
    'TokenMeter 6k-4k-3k-2k': [(0.868, 83.6), (0.954, 84.2), (0.972, 84.6), (0.98, 85.2)],
    'TokenMeter ': [(0.798, 81.6), (0.954, 84.8), (0.96, 85.8), (0.972, 87.4)],
}

fig, ax = plt.subplots(figsize=(10, 6))

colors = ['purple', 'green', 'blue', 'orange', 'red']
markers = ['o', 's', 'D', 'x', '*']

first_points = [list(values)[0] for values in data.values()]

for i, (model, coordinates) in enumerate(data.items()):
    x, y = zip(*coordinates)
    if i < 4:  # 前四组虚线
        ax.plot(y, x, label=model, color=colors[i], marker=markers[i], linestyle='--', markersize=8)  # 交换x和y
        ax.scatter(y, x, color=colors[i], marker=markers[i], s=100)  # 交换x和y
    else:
        ax.plot(y, x, label=model, color=colors[i], marker=markers[i], linestyle='-', markersize=8)  # 交换x和y
        ax.scatter(y, x, color=colors[i], marker=markers[i], s=100)  # 交换x和y

# ax.set_title('MATH500 Accuracy vs Average Length')
ax.set_xlabel('Accuracy (%)')
ax.set_ylabel('Following Budget Ratio')

# 设置y轴刻度间隔
ax.yaxis.set_major_locator(plt.MultipleLocator(0.05))
ax.xaxis.set_major_locator(plt.MultipleLocator(0.5))

ax.legend()

ax.grid(True, which='both', linestyle='--', linewidth=0.5)

plt.savefig('Following_Budget_Ratio.png', bbox_inches='tight')

plt.close()